/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.commands.data.BlockDataAccessor;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.commands.data.StorageDataAccessor;
import net.minecraft.util.Mth;

public class DataCommands {
    private static final SimpleCommandExceptionType ERROR_MERGE_UNCHANGED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType ERROR_GET_NOT_NUMBER = new DynamicCommandExceptionType(p_139491_ -> new TranslatableComponent("commands.data.get.invalid", p_139491_));
    private static final DynamicCommandExceptionType ERROR_GET_NON_EXISTENT = new DynamicCommandExceptionType(p_139481_ -> new TranslatableComponent("commands.data.get.unknown", p_139481_));
    private static final SimpleCommandExceptionType ERROR_MULTIPLE_TAGS = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_LIST = new DynamicCommandExceptionType(p_139468_ -> new TranslatableComponent("commands.data.modify.expected_list", p_139468_));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_OBJECT = new DynamicCommandExceptionType(p_139448_ -> new TranslatableComponent("commands.data.modify.expected_object", p_139448_));
    private static final DynamicCommandExceptionType ERROR_INVALID_INDEX = new DynamicCommandExceptionType(p_139402_ -> new TranslatableComponent("commands.data.modify.invalid_index", p_139402_));
    public static final List<Function<String, DataProvider>> ALL_PROVIDERS = ImmutableList.of(EntityDataAccessor.PROVIDER, BlockDataAccessor.PROVIDER, StorageDataAccessor.PROVIDER);
    public static final List<DataProvider> TARGET_PROVIDERS = (List)ALL_PROVIDERS.stream().map(p_139450_ -> (DataProvider)p_139450_.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<DataProvider> SOURCE_PROVIDERS = (List)ALL_PROVIDERS.stream().map(p_139410_ -> (DataProvider)p_139410_.apply("source")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal("data").requires(p_139381_ -> p_139381_.hasPermission(2));
        for (DataProvider datacommands$dataprovider : TARGET_PROVIDERS) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.then(datacommands$dataprovider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("merge"), p_139471_ -> p_139471_.then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(p_142857_ -> DataCommands.mergeData((CommandSourceStack)p_142857_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_142857_), CompoundTagArgument.getCompoundTag(p_142857_, "nbt"))))))).then(datacommands$dataprovider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("get"), p_139453_ -> p_139453_.executes(p_142849_ -> DataCommands.getData((CommandSourceStack)p_142849_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_142849_))).then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).executes(p_142841_ -> DataCommands.getData((CommandSourceStack)p_142841_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_142841_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142841_, "path")))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_142833_ -> DataCommands.getNumeric((CommandSourceStack)p_142833_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_142833_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142833_, "path"), DoubleArgumentType.getDouble((CommandContext)p_142833_, (String)"scale")))))))).then(datacommands$dataprovider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("remove"), p_139413_ -> p_139413_.then(Commands.argument("path", NbtPathArgument.nbtPath()).executes(p_142820_ -> DataCommands.removeData((CommandSourceStack)p_142820_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_142820_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142820_, "path"))))))).then(DataCommands.decorateModification((p_139368_, p_139369_) -> p_139368_.then(Commands.literal("insert").then(Commands.argument("index", IntegerArgumentType.integer()).then(p_139369_.create((p_142859_, p_142860_, p_142861_, p_142862_) -> {
                int i = IntegerArgumentType.getInteger((CommandContext)p_142859_, (String)"index");
                return DataCommands.insertAtIndex(i, p_142860_, p_142861_, p_142862_);
            })))).then(Commands.literal("prepend").then(p_139369_.create((p_142851_, p_142852_, p_142853_, p_142854_) -> DataCommands.insertAtIndex(0, p_142852_, p_142853_, p_142854_)))).then(Commands.literal("append").then(p_139369_.create((p_142843_, p_142844_, p_142845_, p_142846_) -> DataCommands.insertAtIndex(-1, p_142844_, p_142845_, p_142846_)))).then(Commands.literal("set").then(p_139369_.create((p_142835_, p_142836_, p_142837_, p_142838_) -> p_142837_.set((Tag)p_142836_, ((Tag)Iterables.getLast((Iterable)p_142838_))::copy)))).then(Commands.literal("merge").then(p_139369_.create((p_142822_, p_142823_, p_142824_, p_142825_) -> {
                List<Tag> collection = p_142824_.getOrCreate(p_142823_, CompoundTag::new);
                int i = 0;
                for (Tag tag : collection) {
                    if (!(tag instanceof CompoundTag)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)tag);
                    }
                    CompoundTag compoundtag = (CompoundTag)tag;
                    CompoundTag compoundtag1 = compoundtag.copy();
                    for (Tag tag1 : p_142825_) {
                        if (!(tag1 instanceof CompoundTag)) {
                            throw ERROR_EXPECTED_OBJECT.create((Object)tag1);
                        }
                        compoundtag.merge((CompoundTag)tag1);
                    }
                    i += compoundtag1.equals(compoundtag) ? 0 : 1;
                }
                return i;
            })))));
        }
        pDispatcher.register(literalargumentbuilder);
    }

    private static int insertAtIndex(int p_139361_, CompoundTag p_139362_, NbtPathArgument.NbtPath p_139363_, List<Tag> p_139364_) throws CommandSyntaxException {
        List<Tag> collection = p_139363_.getOrCreate(p_139362_, ListTag::new);
        int i = 0;
        for (Tag tag : collection) {
            if (!(tag instanceof CollectionTag)) {
                throw ERROR_EXPECTED_LIST.create((Object)tag);
            }
            boolean flag = false;
            CollectionTag collectiontag = (CollectionTag)tag;
            int j = p_139361_ < 0 ? collectiontag.size() + p_139361_ + 1 : p_139361_;
            for (Tag tag1 : p_139364_) {
                try {
                    if (!collectiontag.addTag(j, tag1.copy())) continue;
                    ++j;
                    flag = true;
                }
                catch (IndexOutOfBoundsException indexoutofboundsexception) {
                    throw ERROR_INVALID_INDEX.create((Object)j);
                }
            }
            i += flag ? 1 : 0;
        }
        return i;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> decorateModification(BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, DataManipulatorDecorator> p_139404_) {
        LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder = Commands.literal("modify");
        for (DataProvider datacommands$dataprovider : TARGET_PROVIDERS) {
            datacommands$dataprovider.wrap((ArgumentBuilder<CommandSourceStack, ?>)literalargumentbuilder, p_139408_ -> {
                RequiredArgumentBuilder<CommandSourceStack, NbtPathArgument.NbtPath> argumentbuilder = Commands.argument("targetPath", NbtPathArgument.nbtPath());
                for (DataProvider datacommands$dataprovider1 : SOURCE_PROVIDERS) {
                    p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentbuilder, p_142807_ -> datacommands$dataprovider1.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("from"), p_142812_ -> p_142812_.executes(p_142830_ -> {
                        List<Tag> list = Collections.singletonList(datacommands$dataprovider1.access((CommandContext<CommandSourceStack>)p_142830_).getData());
                        return DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_142830_, datacommands$dataprovider, p_142807_, list);
                    }).then(Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(p_142817_ -> {
                        DataAccessor dataaccessor = datacommands$dataprovider1.access((CommandContext<CommandSourceStack>)p_142817_);
                        NbtPathArgument.NbtPath nbtpathargument$nbtpath = NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142817_, "sourcePath");
                        List<Tag> list = nbtpathargument$nbtpath.get(dataaccessor.getData());
                        return DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_142817_, datacommands$dataprovider, p_142807_, list);
                    }))));
                }
                p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentbuilder, p_142799_ -> Commands.literal("value").then(Commands.argument("value", NbtTagArgument.nbtTag()).executes(p_142803_ -> {
                    List<Tag> list = Collections.singletonList(NbtTagArgument.getNbtTag(p_142803_, "value"));
                    return DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_142803_, datacommands$dataprovider, p_142799_, list);
                })));
                return p_139408_.then(argumentbuilder);
            });
        }
        return literalargumentbuilder;
    }

    private static int manipulateData(CommandContext<CommandSourceStack> p_139376_, DataProvider p_139377_, DataManipulator p_139378_, List<Tag> p_139379_) throws CommandSyntaxException {
        DataAccessor dataaccessor = p_139377_.access(p_139376_);
        NbtPathArgument.NbtPath nbtpathargument$nbtpath = NbtPathArgument.getPath(p_139376_, "targetPath");
        CompoundTag compoundtag = dataaccessor.getData();
        int i = p_139378_.modify(p_139376_, compoundtag, nbtpathargument$nbtpath, p_139379_);
        if (i == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        dataaccessor.setData(compoundtag);
        ((CommandSourceStack)p_139376_.getSource()).sendSuccess(dataaccessor.getModifiedSuccess(), true);
        return i;
    }

    private static int removeData(CommandSourceStack pSource, DataAccessor pAccessor, NbtPathArgument.NbtPath pPath) throws CommandSyntaxException {
        CompoundTag compoundtag = pAccessor.getData();
        int i = pPath.remove(compoundtag);
        if (i == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        pAccessor.setData(compoundtag);
        pSource.sendSuccess(pAccessor.getModifiedSuccess(), true);
        return i;
    }

    private static Tag getSingleTag(NbtPathArgument.NbtPath p_139399_, DataAccessor p_139400_) throws CommandSyntaxException {
        List<Tag> collection = p_139399_.get(p_139400_.getData());
        Iterator iterator = collection.iterator();
        Tag tag = (Tag)iterator.next();
        if (iterator.hasNext()) {
            throw ERROR_MULTIPLE_TAGS.create();
        }
        return tag;
    }

    private static int getData(CommandSourceStack pSource, DataAccessor pAccessor, NbtPathArgument.NbtPath pPath) throws CommandSyntaxException {
        int i;
        Tag tag = DataCommands.getSingleTag(pPath, pAccessor);
        if (tag instanceof NumericTag) {
            i = Mth.floor(((NumericTag)tag).getAsDouble());
        } else if (tag instanceof CollectionTag) {
            i = ((CollectionTag)tag).size();
        } else if (tag instanceof CompoundTag) {
            i = ((CompoundTag)tag).size();
        } else {
            if (!(tag instanceof StringTag)) {
                throw ERROR_GET_NON_EXISTENT.create((Object)pPath.toString());
            }
            i = tag.getAsString().length();
        }
        pSource.sendSuccess(pAccessor.getPrintSuccess(tag), false);
        return i;
    }

    private static int getNumeric(CommandSourceStack pSource, DataAccessor pAccessor, NbtPathArgument.NbtPath pPath, double pScale) throws CommandSyntaxException {
        Tag tag = DataCommands.getSingleTag(pPath, pAccessor);
        if (!(tag instanceof NumericTag)) {
            throw ERROR_GET_NOT_NUMBER.create((Object)pPath.toString());
        }
        int i = Mth.floor(((NumericTag)tag).getAsDouble() * pScale);
        pSource.sendSuccess(pAccessor.getPrintSuccess(pPath, pScale, i), false);
        return i;
    }

    private static int getData(CommandSourceStack pSource, DataAccessor pAccessor) throws CommandSyntaxException {
        pSource.sendSuccess(pAccessor.getPrintSuccess(pAccessor.getData()), false);
        return 1;
    }

    private static int mergeData(CommandSourceStack pSource, DataAccessor pAccessor, CompoundTag pNbt) throws CommandSyntaxException {
        CompoundTag compoundtag1;
        CompoundTag compoundtag = pAccessor.getData();
        if (compoundtag.equals(compoundtag1 = compoundtag.copy().merge(pNbt))) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        pAccessor.setData(compoundtag1);
        pSource.sendSuccess(pAccessor.getModifiedSuccess(), true);
        return 1;
    }

    static interface DataManipulator {
        public int modify(CommandContext<CommandSourceStack> var1, CompoundTag var2, NbtPathArgument.NbtPath var3, List<Tag> var4) throws CommandSyntaxException;
    }

    static interface DataManipulatorDecorator {
        public ArgumentBuilder<CommandSourceStack, ?> create(DataManipulator var1);
    }

    public static interface DataProvider {
        public DataAccessor access(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> var1, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2);
    }
}

