/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;

public class StatsComponent
extends JComponent {
    private static final DecimalFormat DECIMAL_FORMAT = Util.make(new DecimalFormat("########0.000"), p_139968_ -> p_139968_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final int[] values = new int[256];
    private int vp;
    private final String[] msgs = new String[11];
    private final MinecraftServer server;
    private final Timer timer;

    public StatsComponent(MinecraftServer p_139963_) {
        this.server = p_139963_;
        this.setPreferredSize(new Dimension(456, 246));
        this.setMinimumSize(new Dimension(456, 246));
        this.setMaximumSize(new Dimension(456, 246));
        this.timer = new Timer(500, p_139966_ -> this.tick());
        this.timer.start();
        this.setBackground(Color.BLACK);
    }

    private void tick() {
        long i = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.msgs[0] = "Memory use: " + i / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.msgs[1] = "Avg tick: " + DECIMAL_FORMAT.format(this.a(this.server.tickTimes) * 1.0E-6) + " ms";
        this.values[this.vp++ & 0xFF] = (int)(i * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    private double a(long[] p_139970_) {
        long i = 0L;
        long[] lArray = p_139970_;
        int n = p_139970_.length;
        int n2 = 0;
        while (n2 < n) {
            long j = lArray[n2];
            i += j;
            ++n2;
        }
        return (double)i / (double)p_139970_.length;
    }

    @Override
    public void paint(Graphics p_139973_) {
        p_139973_.setColor(new Color(0xFFFFFF));
        p_139973_.fillRect(0, 0, 456, 246);
        int i = 0;
        while (i < 256) {
            int j = this.values[i + this.vp & 0xFF];
            p_139973_.setColor(new Color(j + 28 << 16));
            p_139973_.fillRect(i, 100 - j, 1, j);
            ++i;
        }
        p_139973_.setColor(Color.BLACK);
        int k = 0;
        while (k < this.msgs.length) {
            String s = this.msgs[k];
            if (s != null) {
                p_139973_.drawString(s, 32, 116 + k * 16);
            }
            ++k;
        }
    }

    public void close() {
        this.timer.stop();
    }
}

