/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.core.SectionPos;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;

public abstract class SectionTracker
extends DynamicGraphMinFixedPoint {
    protected SectionTracker(int p_8274_, int p_8275_, int p_8276_) {
        super(p_8274_, p_8275_, p_8276_);
    }

    @Override
    protected boolean isSource(long pPos) {
        return pPos == Long.MAX_VALUE;
    }

    @Override
    protected void checkNeighborsAfterUpdate(long pPos, int p_8281_, boolean pLevel) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                int k = -1;
                while (k <= 1) {
                    long l = SectionPos.offset(pPos, i, j, k);
                    if (l != pPos) {
                        this.checkNeighbor(pPos, l, p_8281_, pLevel);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected int getComputedLevel(long pPos, long p_8285_, int pExcludedSourcePos) {
        int i = pExcludedSourcePos;
        int j = -1;
        while (j <= 1) {
            int k = -1;
            while (k <= 1) {
                int l = -1;
                while (l <= 1) {
                    long i1 = SectionPos.offset(pPos, j, k, l);
                    if (i1 == pPos) {
                        i1 = Long.MAX_VALUE;
                    }
                    if (i1 != p_8285_) {
                        int j1 = this.computeLevelFromNeighbor(i1, pPos, this.getLevel(i1));
                        if (i > j1) {
                            i = j1;
                        }
                        if (i == 0) {
                            return i;
                        }
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        return i;
    }

    @Override
    protected int computeLevelFromNeighbor(long pStartPos, long p_8294_, int pEndPos) {
        return pStartPos == Long.MAX_VALUE ? this.getLevelFromSource(p_8294_) : pEndPos + 1;
    }

    protected abstract int getLevelFromSource(long var1);

    public void update(long pPos, int p_8290_, boolean pLevel) {
        this.checkEdge(Long.MAX_VALUE, pPos, p_8290_, pLevel);
    }
}

