/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class ServerBossEvent
extends BossEvent {
    private final Set<ServerPlayer> players = Sets.newHashSet();
    private final Set<ServerPlayer> unmodifiablePlayers = Collections.unmodifiableSet(this.players);
    private boolean visible = true;

    public ServerBossEvent(Component p_8300_, BossEvent.BossBarColor p_8301_, BossEvent.BossBarOverlay p_8302_) {
        super(Mth.createInsecureUUID(), p_8300_, p_8301_, p_8302_);
    }

    @Override
    public void setProgress(float pProgress) {
        if (pProgress != this.progress) {
            super.setProgress(pProgress);
            this.broadcast(ClientboundBossEventPacket::createUpdateProgressPacket);
        }
    }

    @Override
    public void setColor(BossEvent.BossBarColor pColor) {
        if (pColor != this.color) {
            super.setColor(pColor);
            this.broadcast(ClientboundBossEventPacket::createUpdateStylePacket);
        }
    }

    @Override
    public void setOverlay(BossEvent.BossBarOverlay pOverlay) {
        if (pOverlay != this.overlay) {
            super.setOverlay(pOverlay);
            this.broadcast(ClientboundBossEventPacket::createUpdateStylePacket);
        }
    }

    @Override
    public BossEvent setDarkenScreen(boolean pDarkenSky) {
        if (pDarkenSky != this.darkenScreen) {
            super.setDarkenScreen(pDarkenSky);
            this.broadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public BossEvent setPlayBossMusic(boolean pPlayEndBossMusic) {
        if (pPlayEndBossMusic != this.playBossMusic) {
            super.setPlayBossMusic(pPlayEndBossMusic);
            this.broadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public BossEvent setCreateWorldFog(boolean pCreateFog) {
        if (pCreateFog != this.createWorldFog) {
            super.setCreateWorldFog(pCreateFog);
            this.broadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public void setName(Component pName) {
        if (!Objects.equal((Object)pName, (Object)this.name)) {
            super.setName(pName);
            this.broadcast(ClientboundBossEventPacket::createUpdateNamePacket);
        }
    }

    private void broadcast(Function<BossEvent, ClientboundBossEventPacket> p_143225_) {
        if (this.visible) {
            ClientboundBossEventPacket clientboundbosseventpacket = p_143225_.apply(this);
            for (ServerPlayer serverplayer : this.players) {
                serverplayer.connection.send(clientboundbosseventpacket);
            }
        }
    }

    public void addPlayer(ServerPlayer pPlayer) {
        if (this.players.add(pPlayer) && this.visible) {
            pPlayer.connection.send(ClientboundBossEventPacket.createAddPacket(this));
        }
    }

    public void removePlayer(ServerPlayer pPlayer) {
        if (this.players.remove(pPlayer) && this.visible) {
            pPlayer.connection.send(ClientboundBossEventPacket.createRemovePacket(this.getId()));
        }
    }

    public void removeAllPlayers() {
        if (!this.players.isEmpty()) {
            for (ServerPlayer serverplayer : Lists.newArrayList(this.players)) {
                this.removePlayer(serverplayer);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean pVisible) {
        if (pVisible != this.visible) {
            this.visible = pVisible;
            for (ServerPlayer serverplayer : this.players) {
                serverplayer.connection.send(pVisible ? ClientboundBossEventPacket.createAddPacket(this) : ClientboundBossEventPacket.createRemovePacket(this.getId()));
            }
        }
    }

    public Collection<ServerPlayer> getPlayers() {
        return this.unmodifiablePlayers;
    }
}

