/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;

public class TicketType<T> {
    private final String name;
    private final Comparator<T> comparator;
    private final long timeout;
    public static final TicketType<Unit> START = TicketType.create("start", (p_9471_, p_9472_) -> 0);
    public static final TicketType<Unit> DRAGON = TicketType.create("dragon", (p_9460_, p_9461_) -> 0);
    public static final TicketType<ChunkPos> PLAYER = TicketType.create("player", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<ChunkPos> FORCED = TicketType.create("forced", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<ChunkPos> LIGHT = TicketType.create("light", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<BlockPos> PORTAL = TicketType.create("portal", Vec3i::compareTo, 300);
    public static final TicketType<Integer> POST_TELEPORT = TicketType.create("post_teleport", Integer::compareTo, 5);
    public static final TicketType<ChunkPos> h = TicketType.create("unknown", Comparator.comparingLong(ChunkPos::toLong), 1);

    public static <T> TicketType<T> create(String pName, Comparator<T> pComparator) {
        return new TicketType<T>(pName, pComparator, 0L);
    }

    public static <T> TicketType<T> create(String pName, Comparator<T> pComparator, int pLifespan) {
        return new TicketType<T>(pName, pComparator, pLifespan);
    }

    protected TicketType(String p_9455_, Comparator<T> p_9456_, long p_9457_) {
        this.name = p_9455_;
        this.comparator = p_9456_;
        this.timeout = p_9457_;
    }

    public String toString() {
        return this.name;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public long timeout() {
        return this.timeout;
    }
}

