/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatusPacketListener;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.MinecraftServer;

public class ServerStatusPacketListenerImpl
implements ServerStatusPacketListener {
    private static final Component DISCONNECT_REASON = new TranslatableComponent("multiplayer.status.request_handled");
    private final MinecraftServer server;
    private final Connection connection;
    private boolean hasRequestedStatus;

    public ServerStatusPacketListenerImpl(MinecraftServer p_10087_, Connection p_10088_) {
        this.server = p_10087_;
        this.connection = p_10088_;
    }

    @Override
    public void onDisconnect(Component pReason) {
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void handleStatusRequest(ServerboundStatusRequestPacket pPacket) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
        } else {
            this.hasRequestedStatus = true;
            this.connection.send(new ClientboundStatusResponsePacket(this.server.getStatus()));
        }
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket pPacket) {
        this.connection.send(new ClientboundPongResponsePacket(pPacket.getTime()));
        this.connection.disconnect(DISCONNECT_REASON);
    }
}

