/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public abstract class AbstractPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final File file;

    public AbstractPackResources(File p_10207_) {
        this.file = p_10207_;
    }

    private static String getPathFromLocation(PackType pType, ResourceLocation pLocation) {
        return String.format("%s/%s/%s", pType.getDirectory(), pLocation.getNamespace(), pLocation.getPath());
    }

    protected static String getRelativePath(File pFile1, File pFile2) {
        return pFile1.toURI().relativize(pFile2.toURI()).getPath();
    }

    @Override
    public InputStream getResource(PackType pType, ResourceLocation pLocation) throws IOException {
        return this.getResource(AbstractPackResources.getPathFromLocation(pType, pLocation));
    }

    @Override
    public boolean hasResource(PackType pType, ResourceLocation pLocation) {
        return this.hasResource(AbstractPackResources.getPathFromLocation(pType, pLocation));
    }

    protected abstract InputStream getResource(String var1) throws IOException;

    @Override
    public InputStream getRootResource(String pFileName) throws IOException {
        if (!pFileName.contains("/") && !pFileName.contains("\\")) {
            return this.getResource(pFileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected abstract boolean hasResource(String var1);

    protected void logWarning(String pNamespace) {
        LOGGER.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)pNamespace, (Object)this.file);
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> pDeserializer) throws IOException {
        T object;
        try (InputStream inputstream = this.getResource("pack.mcmeta");){
            object = AbstractPackResources.getMetadataFromStream(pDeserializer, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionSerializer<T> pDeserializer, InputStream pInputStream) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(pInputStream, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.parse(bufferedreader);
        }
        catch (Exception exception1) {
            LOGGER.error("Couldn't load {} metadata", (Object)pDeserializer.getMetadataSectionName(), (Object)exception1);
            return null;
        }
        if (!jsonobject.has(pDeserializer.getMetadataSectionName())) {
            return null;
        }
        try {
            return pDeserializer.fromJson(GsonHelper.getAsJsonObject(jsonobject, pDeserializer.getMetadataSectionName()));
        }
        catch (Exception exception1) {
            LOGGER.error("Couldn't load {} metadata", (Object)pDeserializer.getMetadataSectionName(), (Object)exception1);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s", this.getClass().getName(), this.file.getPath());
    }
}

