/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import org.apache.commons.io.IOUtils;

public class FilePackResources
extends AbstractPackResources {
    public static final Splitter SPLITTER = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    @Nullable
    private ZipFile zipFile;

    public FilePackResources(File p_10236_) {
        super(p_10236_);
    }

    private ZipFile getOrCreateZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
        return this.zipFile;
    }

    @Override
    protected InputStream getResource(String pResourcePath) throws IOException {
        ZipFile zipfile = this.getOrCreateZipFile();
        ZipEntry zipentry = zipfile.getEntry(pResourcePath);
        if (zipentry == null) {
            throw new ResourcePackFileNotFoundException(this.file, pResourcePath);
        }
        return zipfile.getInputStream(zipentry);
    }

    @Override
    public boolean hasResource(String pResourcePath) {
        try {
            return this.getOrCreateZipFile().getEntry(pResourcePath) != null;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set<String> getNamespaces(PackType pType) {
        ZipFile zipfile;
        try {
            zipfile = this.getOrCreateZipFile();
        }
        catch (IOException ioexception) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet set = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipentry = enumeration.nextElement();
            String s = zipentry.getName();
            if (!s.startsWith(String.valueOf(pType.getDirectory()) + "/") || (list = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)s))).size() <= 1) continue;
            String s1 = (String)list.get(1);
            if (s1.equals(s1.toLowerCase(Locale.ROOT))) {
                set.add(s1);
                continue;
            }
            this.logWarning(s1);
        }
        return set;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            IOUtils.closeQuietly((Closeable)this.zipFile);
            this.zipFile = null;
        }
    }

    @Override
    public Collection<ResourceLocation> getResources(PackType pType, String pNamespace, String pPath, int pMaxDepth, Predicate<String> pFilter) {
        ZipFile zipfile;
        try {
            zipfile = this.getOrCreateZipFile();
        }
        catch (IOException ioexception) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        ArrayList list = Lists.newArrayList();
        String s = String.valueOf(pType.getDirectory()) + "/" + pNamespace + "/";
        String s1 = String.valueOf(s) + pPath + "/";
        while (enumeration.hasMoreElements()) {
            String s3;
            String[] astring;
            String s2;
            ZipEntry zipentry = enumeration.nextElement();
            if (zipentry.isDirectory() || (s2 = zipentry.getName()).endsWith(".mcmeta") || !s2.startsWith(s1) || (astring = (s3 = s2.substring(s.length())).split("/")).length < pMaxDepth + 1 || !pFilter.test(astring[astring.length - 1])) continue;
            list.add(new ResourceLocation(pNamespace, s3));
        }
        return list;
    }
}

