/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources,
ResourceProvider {
    @Nullable
    public static Path generatedDir;
    private static final Logger LOGGER;
    public static Class<?> clientObject;
    private static final Map<PackType, Path> ROOT_DIR_BY_TYPE;
    public final PackMetadataSection packMetadata;
    public final Set<String> namespaces;
    private static final boolean ON_WINDOWS;
    private static final boolean FORGE;

    static {
        LOGGER = LogUtils.getLogger();
        ROOT_DIR_BY_TYPE = (Map)Util.make(() -> {
            Class<VanillaPackResources> clazz = VanillaPackResources.class;
            synchronized (VanillaPackResources.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                PackType[] packTypeArray = PackType.values();
                int n = packTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PackType packtype = packTypeArray[n2];
                    String s = "/" + packtype.getDirectory() + "/.mcassetsroot";
                    URL url = VanillaPackResources.class.getResource(s);
                    if (url == null) {
                        LOGGER.error("File {} does not exist in classpath", (Object)s);
                    } else {
                        try {
                            URI uri = url.toURI();
                            String s1 = uri.getScheme();
                            if (!"jar".equals(s1) && !"file".equals(s1)) {
                                LOGGER.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                            }
                            Path path = VanillaPackResources.safeGetPath(uri);
                            builder.put((Object)packtype, (Object)path.getParent());
                        }
                        catch (Exception exception1) {
                            LOGGER.error("Couldn't resolve path to vanilla assets", (Throwable)exception1);
                        }
                    }
                    ++n2;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
        ON_WINDOWS = Util.getPlatform() == Util.OS.WINDOWS;
        FORGE = Reflector.ForgeHooksClient.exists();
    }

    private static Path safeGetPath(URI p_182298_) throws IOException {
        try {
            return Paths.get(p_182298_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            LOGGER.warn("Unable to get path for: {}", (Object)p_182298_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_182298_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_182298_);
    }

    public VanillaPackResources(PackMetadataSection p_143761_, String ... p_143762_) {
        this.packMetadata = p_143761_;
        this.namespaces = ImmutableSet.copyOf((Object[])p_143762_);
    }

    @Override
    public InputStream getRootResource(String pFileName) throws IOException {
        if (!pFileName.contains("/") && !pFileName.contains("\\")) {
            Path path;
            if (generatedDir != null && Files.exists(path = generatedDir.resolve(pFileName), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.getResourceAsStream(pFileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream getResource(PackType pType, ResourceLocation pLocation) throws IOException {
        InputStream inputstream = this.getResourceAsStream(pType, pLocation);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(pLocation.getPath());
    }

    @Override
    public Collection<ResourceLocation> getResources(PackType pType, String pNamespace, String pPath, int pMaxDepth, Predicate<String> pFilter) {
        HashSet set = Sets.newHashSet();
        if (generatedDir != null) {
            try {
                VanillaPackResources.getResources(set, pMaxDepth, pNamespace, generatedDir.resolve(pType.getDirectory()), pPath, pFilter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (pType == PackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = clientObject.getClassLoader().getResources(String.valueOf(pType.getDirectory()) + "/");
                }
                catch (IOException iOException) {}
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = ((URL)enumeration.nextElement()).toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        VanillaPackResources.getResources(set, pMaxDepth, pNamespace, Paths.get(uri), pPath, pFilter);
                    }
                    catch (IOException | URISyntaxException exception) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            Path path = ROOT_DIR_BY_TYPE.get((Object)pType);
            if (path != null) {
                VanillaPackResources.getResources(set, pMaxDepth, pNamespace, path, pPath, pFilter);
            } else {
                LOGGER.error("Can't access assets root for type: {}", (Object)pType);
            }
        }
        catch (FileNotFoundException | NoSuchFileException path) {
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't get a list of all vanilla resources", (Throwable)ioexception1);
        }
        return set;
    }

    private static void getResources(Collection<ResourceLocation> pResourceLocations, int pMaxDepth, String pNamespace, Path pPath, String pPathName, Predicate<String> pFilter) throws IOException {
        Path path = pPath.resolve(pNamespace);
        try (Stream<Path> stream = Files.walk(path.resolve(pPathName), pMaxDepth, new FileVisitOption[0]);){
            stream.filter(p_10351_1_ -> !p_10351_1_.endsWith(".mcmeta") && Files.isRegularFile(p_10351_1_, new LinkOption[0]) && pFilter.test(p_10351_1_.getFileName().toString())).map(p_10338_2_ -> new ResourceLocation(pNamespace, path.relativize((Path)p_10338_2_).toString().replaceAll("\\\\", "/"))).forEach(pResourceLocations::add);
        }
    }

    @Nullable
    protected InputStream getResourceAsStream(PackType pType, ResourceLocation pLocation) {
        Path path;
        String s = VanillaPackResources.createPath(pType, pLocation);
        InputStream inputstream = ReflectorForge.getOptiFineResourceStream(s);
        if (inputstream != null) {
            return inputstream;
        }
        if (generatedDir != null && Files.exists(path = generatedDir.resolve(String.valueOf(pType.getDirectory()) + "/" + pLocation.getNamespace() + "/" + pLocation.getPath()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.isResourceUrlValid(s, url) ? (FORGE ? this.getExtraInputStream(pType, s) : url.openStream()) : null;
        }
        catch (IOException ioexception1) {
            return VanillaPackResources.class.getResourceAsStream(s);
        }
    }

    private static String createPath(PackType pPackType, ResourceLocation pLocation) {
        return "/" + pPackType.getDirectory() + "/" + pLocation.getNamespace() + "/" + pLocation.getPath();
    }

    private static boolean isResourceUrlValid(String pPath, @Nullable URL pUrl) throws IOException {
        return pUrl != null && (pUrl.getProtocol().equals("jar") || VanillaPackResources.validatePath(new File(pUrl.getFile()), pPath));
    }

    @Nullable
    protected InputStream getResourceAsStream(String pPath) {
        return FORGE ? this.getExtraInputStream(PackType.SERVER_DATA, "/" + pPath) : VanillaPackResources.class.getResourceAsStream("/" + pPath);
    }

    @Override
    public boolean hasResource(PackType pType, ResourceLocation pLocation) {
        Path path;
        String s = VanillaPackResources.createPath(pType, pLocation);
        InputStream inputstream = ReflectorForge.getOptiFineResourceStream(s);
        if (inputstream != null) {
            return true;
        }
        if (generatedDir != null && Files.exists(path = generatedDir.resolve(String.valueOf(pType.getDirectory()) + "/" + pLocation.getNamespace() + "/" + pLocation.getPath()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.isResourceUrlValid(s, url);
        }
        catch (IOException ioexception1) {
            return false;
        }
    }

    @Override
    public Set<String> getNamespaces(PackType pType) {
        return this.namespaces;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> pDeserializer) throws IOException {
        try {
            T object;
            block9: {
                block8: {
                    try (InputStream inputstream = this.getRootResource("pack.mcmeta");){
                        T t;
                        if (inputstream == null || (t = AbstractPackResources.getMetadataFromStream(pDeserializer, inputstream)) == null) break block8;
                        object = t;
                        break block9;
                    }
                }
                return (T)(pDeserializer == PackMetadataSection.SERIALIZER ? this.packMetadata : null);
            }
            return object;
        }
        catch (FileNotFoundException | RuntimeException filenotfoundexception) {
            return (T)(pDeserializer == PackMetadataSection.SERIALIZER ? this.packMetadata : null);
        }
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public void close() {
    }

    @Override
    public Resource getResource(ResourceLocation p_143764_) throws IOException {
        return new Resource(){
            @Nullable
            InputStream inputStream;

            @Override
            public void close() throws IOException {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }

            @Override
            public ResourceLocation getLocation() {
                return p_143764_;
            }

            @Override
            public InputStream getInputStream() {
                try {
                    this.inputStream = VanillaPackResources.this.getResource(PackType.CLIENT_RESOURCES, p_143764_);
                }
                catch (IOException ioexception) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", ioexception);
                }
                return this.inputStream;
            }

            @Override
            public boolean hasMetadata() {
                return false;
            }

            @Override
            @Nullable
            public <T> T getMetadata(MetadataSectionSerializer<T> p_143773_) {
                return null;
            }

            @Override
            public String getSourceName() {
                return p_143764_.toString();
            }
        };
    }

    private static boolean validatePath(File file, String path) throws IOException {
        String s = file.getPath();
        if (s.startsWith("file:")) {
            if (ON_WINDOWS) {
                s = s.replace("\\", "/");
            }
            return s.endsWith(path);
        }
        return FolderPackResources.validatePath(file, path);
    }

    private InputStream getExtraInputStream(PackType type, String resource) {
        try {
            Path path = ROOT_DIR_BY_TYPE.get((Object)type);
            return path != null ? Files.newInputStream(path.resolve(resource), new OpenOption[0]) : VanillaPackResources.class.getResourceAsStream(resource);
        }
        catch (IOException ioexception) {
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
    }
}

