/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.io.File;
import java.io.FileFilter;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public class FolderRepositorySource
implements RepositorySource {
    private static final FileFilter RESOURCEPACK_FILTER = p_10398_ -> {
        boolean flag1;
        boolean flag = p_10398_.isFile() && p_10398_.getName().endsWith(".zip");
        boolean bl = flag1 = p_10398_.isDirectory() && new File(p_10398_, "pack.mcmeta").isFile();
        return flag || flag1;
    };
    private final File folder;
    private final PackSource packSource;

    public FolderRepositorySource(File p_10386_, PackSource p_10387_) {
        this.folder = p_10386_;
        this.packSource = p_10387_;
    }

    @Override
    public void loadPacks(Consumer<Pack> pInfoConsumer, Pack.PackConstructor pInfoFactory) {
        File[] afile;
        if (!this.folder.isDirectory()) {
            this.folder.mkdirs();
        }
        if ((afile = this.folder.listFiles(RESOURCEPACK_FILTER)) != null) {
            File[] fileArray = afile;
            int n = afile.length;
            int n2 = 0;
            while (n2 < n) {
                File file1 = fileArray[n2];
                String s = "file/" + file1.getName();
                Pack pack = Pack.create(s, false, this.createSupplier(file1), pInfoFactory, Pack.Position.TOP, this.packSource);
                if (pack != null) {
                    pInfoConsumer.accept(pack);
                }
                ++n2;
            }
        }
    }

    private Supplier<PackResources> createSupplier(File pFile) {
        return pFile.isDirectory() ? () -> new FolderPackResources(pFile) : () -> new FilePackResources(pFile);
    }
}

