/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public class PackRepository
implements AutoCloseable {
    private final Set<RepositorySource> sources;
    private Map<String, Pack> available = ImmutableMap.of();
    private List<Pack> selected = ImmutableList.of();
    private final Pack.PackConstructor constructor;

    public PackRepository(Pack.PackConstructor p_10502_, RepositorySource ... p_10503_) {
        this.constructor = p_10502_;
        this.sources = ImmutableSet.copyOf((Object[])p_10503_);
    }

    public PackRepository(PackType p_143890_, RepositorySource ... p_143891_) {
        this((String p_143894_, Component p_143895_, boolean p_143896_, Supplier<PackResources> p_143897_, PackMetadataSection p_143898_, Pack.Position p_143899_, PackSource p_143900_) -> new Pack(p_143894_, p_143895_, p_143896_, p_143897_, p_143898_, p_143890_, p_143899_, p_143900_), p_143891_);
    }

    public void reload() {
        List list = (List)this.selected.stream().map(Pack::getId).collect(ImmutableList.toImmutableList());
        this.close();
        this.available = this.discoverAvailable();
        this.selected = this.rebuildSelected(list);
    }

    private Map<String, Pack> discoverAvailable() {
        TreeMap map = Maps.newTreeMap();
        for (RepositorySource repositorysource : this.sources) {
            repositorysource.loadPacks(p_143903_ -> map.put(p_143903_.getId(), p_143903_), this.constructor);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    public void setSelected(Collection<String> p_10510_) {
        this.selected = this.rebuildSelected(p_10510_);
    }

    private List<Pack> rebuildSelected(Collection<String> p_10518_) {
        List list = this.getAvailablePacks(p_10518_).collect(Collectors.toList());
        for (Pack pack : this.available.values()) {
            if (!pack.isRequired() || list.contains(pack)) continue;
            pack.getDefaultPosition().insert(list, pack, Functions.identity(), false);
        }
        return ImmutableList.copyOf(list);
    }

    private Stream<Pack> getAvailablePacks(Collection<String> p_10521_) {
        return p_10521_.stream().map(this.available::get).filter(Objects::nonNull);
    }

    public Collection<String> getAvailableIds() {
        return this.available.keySet();
    }

    public Collection<Pack> getAvailablePacks() {
        return this.available.values();
    }

    public Collection<String> getSelectedIds() {
        return (Collection)this.selected.stream().map(Pack::getId).collect(ImmutableSet.toImmutableSet());
    }

    public Collection<Pack> getSelectedPacks() {
        return this.selected;
    }

    @Nullable
    public Pack getPack(String pName) {
        return this.available.get(pName);
    }

    @Override
    public void close() {
        this.available.values().forEach(Pack::close);
    }

    public boolean isAvailable(String p_10516_) {
        return this.available.containsKey(p_10516_);
    }

    public List<PackResources> openAllSelected() {
        return (List)this.selected.stream().map(Pack::open).collect(ImmutableList.toImmutableList());
    }
}

