/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleResource;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<PackResources> fallbacks = Lists.newArrayList();
    private final PackType type;
    private final String namespace;

    public FallbackResourceManager(PackType p_10605_, String p_10606_) {
        this.type = p_10605_;
        this.namespace = p_10606_;
    }

    public void add(PackResources pResourcePack) {
        this.fallbacks.add(pResourcePack);
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Resource getResource(ResourceLocation p_10614_) throws IOException {
        this.validateLocation(p_10614_);
        PackResources packresources = null;
        ResourceLocation resourcelocation = FallbackResourceManager.getMetadataLocation(p_10614_);
        int i = this.fallbacks.size() - 1;
        while (i >= 0) {
            PackResources packresources1 = this.fallbacks.get(i);
            if (packresources == null && packresources1.hasResource(this.type, resourcelocation)) {
                packresources = packresources1;
            }
            if (packresources1.hasResource(this.type, p_10614_)) {
                InputStream inputstream = null;
                if (packresources != null) {
                    inputstream = this.getWrappedResource(resourcelocation, packresources);
                }
                return new SimpleResource(packresources1.getName(), p_10614_, this.getWrappedResource(p_10614_, packresources1), inputstream);
            }
            --i;
        }
        throw new FileNotFoundException(p_10614_.toString());
    }

    @Override
    public boolean hasResource(ResourceLocation pPath) {
        if (!this.isValidLocation(pPath)) {
            return false;
        }
        int i = this.fallbacks.size() - 1;
        while (i >= 0) {
            PackResources packresources = this.fallbacks.get(i);
            if (packresources.hasResource(this.type, pPath)) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected InputStream getWrappedResource(ResourceLocation pLocation, PackResources pResourcePack) throws IOException {
        InputStream inputstream = pResourcePack.getResource(this.type, pLocation);
        return LOGGER.isDebugEnabled() ? new LeakedResourceWarningInputStream(inputstream, pLocation, pResourcePack.getName()) : inputstream;
    }

    private void validateLocation(ResourceLocation pLocation) throws IOException {
        if (!this.isValidLocation(pLocation)) {
            throw new IOException("Invalid relative path to resource: " + pLocation);
        }
    }

    private boolean isValidLocation(ResourceLocation p_10629_) {
        return !p_10629_.getPath().contains("..");
    }

    @Override
    public List<Resource> getResources(ResourceLocation pResourceLocation) throws IOException {
        this.validateLocation(pResourceLocation);
        ArrayList list = Lists.newArrayList();
        ResourceLocation resourcelocation = FallbackResourceManager.getMetadataLocation(pResourceLocation);
        for (PackResources packresources : this.fallbacks) {
            if (!packresources.hasResource(this.type, pResourceLocation)) continue;
            InputStream inputstream = packresources.hasResource(this.type, resourcelocation) ? this.getWrappedResource(resourcelocation, packresources) : null;
            list.add(new SimpleResource(packresources.getName(), pResourceLocation, this.getWrappedResource(pResourceLocation, packresources), inputstream));
        }
        if (list.isEmpty()) {
            throw new FileNotFoundException(pResourceLocation.toString());
        }
        return list;
    }

    @Override
    public Collection<ResourceLocation> listResources(String pPath, Predicate<String> pFilter) {
        ArrayList list = Lists.newArrayList();
        for (PackResources packresources : this.fallbacks) {
            list.addAll(packresources.getResources(this.type, this.namespace, pPath, Integer.MAX_VALUE, pFilter));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.fallbacks.stream();
    }

    static ResourceLocation getMetadataLocation(ResourceLocation pLocation) {
        return new ResourceLocation(pLocation.getNamespace(), String.valueOf(pLocation.getPath()) + ".mcmeta");
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final String message;
        private boolean closed;

        public LeakedResourceWarningInputStream(InputStream p_10633_, ResourceLocation p_10634_, String p_10635_) {
            super(p_10633_);
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(bytearrayoutputstream));
            this.message = "Leaked resource: '" + p_10634_ + "' loaded from pack: '" + p_10635_ + "'\n" + bytearrayoutputstream;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn(this.message);
            }
            super.finalize();
        }
    }
}

