/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class MultiPackResourceManager
implements CloseableResourceManager {
    private final Map<String, FallbackResourceManager> namespacedManagers;
    private final List<PackResources> packs;

    public MultiPackResourceManager(PackType p_203797_, List<PackResources> p_203798_) {
        this.packs = List.copyOf(p_203798_);
        HashMap<String, FallbackResourceManager> map = new HashMap<String, FallbackResourceManager>();
        for (PackResources packresources : p_203798_) {
            for (String s : packresources.getNamespaces(p_203797_)) {
                map.computeIfAbsent(s, p_203802_ -> new FallbackResourceManager(p_203797_, (String)p_203802_)).add(packresources);
            }
        }
        this.namespacedManagers = map;
    }

    @Override
    public Set<String> getNamespaces() {
        return this.namespacedManagers.keySet();
    }

    @Override
    public Resource getResource(ResourceLocation p_203813_) throws IOException {
        ResourceManager resourcemanager = this.namespacedManagers.get(p_203813_.getNamespace());
        if (resourcemanager != null) {
            return resourcemanager.getResource(p_203813_);
        }
        throw new FileNotFoundException(p_203813_.toString());
    }

    @Override
    public boolean hasResource(ResourceLocation p_203807_) {
        ResourceManager resourcemanager = this.namespacedManagers.get(p_203807_.getNamespace());
        return resourcemanager != null ? resourcemanager.hasResource(p_203807_) : false;
    }

    @Override
    public List<Resource> getResources(ResourceLocation p_203810_) throws IOException {
        ResourceManager resourcemanager = this.namespacedManagers.get(p_203810_.getNamespace());
        if (resourcemanager != null) {
            return resourcemanager.getResources(p_203810_);
        }
        throw new FileNotFoundException(p_203810_.toString());
    }

    @Override
    public Collection<ResourceLocation> listResources(String p_203804_, Predicate<String> p_203805_) {
        HashSet set = Sets.newHashSet();
        for (FallbackResourceManager fallbackresourcemanager : this.namespacedManagers.values()) {
            set.addAll(fallbackresourcemanager.listResources(p_203804_, p_203805_));
        }
        ArrayList list = Lists.newArrayList((Iterable)set);
        Collections.sort(list);
        return list;
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.packs.stream();
    }

    @Override
    public void close() {
        this.packs.forEach(PackResources::close);
    }
}

