/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;

public interface ResourceManager
extends ResourceProvider {
    public Set<String> getNamespaces();

    public boolean hasResource(ResourceLocation var1);

    public List<Resource> getResources(ResourceLocation var1) throws IOException;

    public Collection<ResourceLocation> listResources(String var1, Predicate<String> var2);

    public Stream<PackResources> listPacks();

    public static enum Empty implements ResourceManager
    {
        INSTANCE;


        @Override
        public Set<String> getNamespaces() {
            return ImmutableSet.of();
        }

        @Override
        public Resource getResource(ResourceLocation p_10742_) throws IOException {
            throw new FileNotFoundException(p_10742_.toString());
        }

        @Override
        public boolean hasResource(ResourceLocation pPath) {
            return false;
        }

        @Override
        public List<Resource> getResources(ResourceLocation pResourceLocation) {
            return ImmutableList.of();
        }

        @Override
        public Collection<ResourceLocation> listResources(String pPath, Predicate<String> pFilter) {
            return ImmutableSet.of();
        }

        @Override
        public Stream<PackResources> listPacks() {
            return Stream.of(new PackResources[0]);
        }
    }
}

