/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;

    public SimpleJsonResourceReloadListener(Gson p_10768_, String p_10769_) {
        this.gson = p_10768_;
        this.directory = p_10769_;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (ResourceLocation resourcelocation : pResourceManager.listResources(this.directory, p_10774_ -> p_10774_.endsWith(PATH_SUFFIX))) {
            String s = resourcelocation.getPath();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.getNamespace(), s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
            try (Resource resource = pResourceManager.getResource(resourcelocation);
                 InputStream inputstream = resource.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                JsonElement jsonelement = GsonHelper.fromJson(this.gson, (Reader)reader, JsonElement.class);
                if (jsonelement != null) {
                    JsonElement jsonelement1 = map.put(resourcelocation1, jsonelement);
                    if (jsonelement1 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                }
                LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourcelocation1, (Object)resourcelocation);
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourcelocation1, resourcelocation, jsonparseexception});
            }
        }
        return map;
    }
}

