/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class GameProfileCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private static boolean usesAuthentication;
    private final Map<String, GameProfileInfo> profilesByName = Maps.newConcurrentMap();
    private final Map<UUID, GameProfileInfo> profilesByUUID = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> requests = Maps.newConcurrentMap();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();
    @Nullable
    private Executor executor;

    public GameProfileCache(GameProfileRepository p_10974_, File p_10975_) {
        this.profileRepository = p_10974_;
        this.file = p_10975_;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(GameProfileInfo p_10980_) {
        UUID uuid;
        GameProfile gameprofile = p_10980_.getProfile();
        p_10980_.setLastAccess(this.getNextOperation());
        String s = gameprofile.getName();
        if (s != null) {
            this.profilesByName.put(s.toLowerCase(Locale.ROOT), p_10980_);
        }
        if ((uuid = gameprofile.getId()) != null) {
            this.profilesByUUID.put(uuid, p_10980_);
        }
    }

    private static Optional<GameProfile> lookupGameProfile(GameProfileRepository pProfileRepo, String pName) {
        AtomicReference atomicreference = new AtomicReference();
        ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_11017_) {
                atomicreference.set(p_11017_);
            }

            public void onProfileLookupFailed(GameProfile p_11014_, Exception p_11015_) {
                atomicreference.set(null);
            }
        };
        pProfileRepo.findProfilesByNames(new String[]{pName}, Agent.MINECRAFT, profilelookupcallback);
        GameProfile gameprofile = (GameProfile)atomicreference.get();
        if (!GameProfileCache.usesAuthentication() && gameprofile == null) {
            UUID uuid = Player.createPlayerUUID(new GameProfile(null, pName));
            return Optional.of(new GameProfile(uuid, pName));
        }
        return Optional.ofNullable(gameprofile);
    }

    public static void setUsesAuthentication(boolean pOnlineMode) {
        usesAuthentication = pOnlineMode;
    }

    private static boolean usesAuthentication() {
        return usesAuthentication;
    }

    public void add(GameProfile pGameProfile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        GameProfileInfo gameprofilecache$gameprofileinfo = new GameProfileInfo(pGameProfile, date);
        this.safeAdd(gameprofilecache$gameprofileinfo);
        this.save();
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    public Optional<GameProfile> get(String pName) {
        Optional<GameProfile> optional;
        String s = pName.toLowerCase(Locale.ROOT);
        GameProfileInfo gameprofilecache$gameprofileinfo = this.profilesByName.get(s);
        boolean flag = false;
        if (gameprofilecache$gameprofileinfo != null && new Date().getTime() >= gameprofilecache$gameprofileinfo.expirationDate.getTime()) {
            this.profilesByUUID.remove(gameprofilecache$gameprofileinfo.getProfile().getId());
            this.profilesByName.remove(gameprofilecache$gameprofileinfo.getProfile().getName().toLowerCase(Locale.ROOT));
            flag = true;
            gameprofilecache$gameprofileinfo = null;
        }
        if (gameprofilecache$gameprofileinfo != null) {
            gameprofilecache$gameprofileinfo.setLastAccess(this.getNextOperation());
            optional = Optional.of(gameprofilecache$gameprofileinfo.getProfile());
        } else {
            optional = GameProfileCache.lookupGameProfile(this.profileRepository, s);
            if (optional.isPresent()) {
                this.add(optional.get());
                flag = false;
            }
        }
        if (flag) {
            this.save();
        }
        return optional;
    }

    public void getAsync(String p_143968_, Consumer<Optional<GameProfile>> p_143969_) {
        if (this.executor == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completablefuture = this.requests.get(p_143968_);
        if (completablefuture != null) {
            this.requests.put(p_143968_, (CompletableFuture<Optional<GameProfile>>)completablefuture.whenCompleteAsync((p_143984_, p_143985_) -> p_143969_.accept((Optional<GameProfile>)p_143984_), this.executor));
        } else {
            this.requests.put(p_143968_, (CompletableFuture<Optional<GameProfile>>)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.get(p_143968_), Util.backgroundExecutor()).whenCompleteAsync((p_143965_, p_143966_) -> this.requests.remove(p_143968_), this.executor)).whenCompleteAsync((p_143978_, p_143979_) -> p_143969_.accept((Optional<GameProfile>)p_143978_), this.executor));
        }
    }

    public Optional<GameProfile> get(UUID pName) {
        GameProfileInfo gameprofilecache$gameprofileinfo = this.profilesByUUID.get(pName);
        if (gameprofilecache$gameprofileinfo == null) {
            return Optional.empty();
        }
        gameprofilecache$gameprofileinfo.setLastAccess(this.getNextOperation());
        return Optional.of(gameprofilecache$gameprofileinfo.getProfile());
    }

    public void setExecutor(Executor p_143975_) {
        this.executor = p_143975_;
    }

    public void clearExecutor() {
        this.executor = null;
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    public List<GameProfileInfo> load() {
        ArrayList list = Lists.newArrayList();
        try {
            ArrayList object;
            block10: {
                try (BufferedReader reader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
                    JsonArray jsonarray = (JsonArray)this.gson.fromJson((Reader)reader, JsonArray.class);
                    if (jsonarray == null) {
                        object = list;
                        break block10;
                    }
                    DateFormat dateformat = GameProfileCache.createDateFormat();
                    jsonarray.forEach(p_143973_ -> GameProfileCache.readGameProfile(p_143973_, dateformat).ifPresent(list::add));
                }
                return list;
            }
            return object;
        }
        catch (FileNotFoundException reader) {
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)ioexception);
        }
        return list;
    }

    public void save() {
        JsonArray jsonarray = new JsonArray();
        DateFormat dateformat = GameProfileCache.createDateFormat();
        this.getTopMRUProfiles(1000).forEach(p_143962_ -> jsonarray.add(GameProfileCache.writeGameProfile(p_143962_, dateformat)));
        String s = this.gson.toJson((JsonElement)jsonarray);
        try (BufferedWriter writer = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            writer.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<GameProfileInfo> getTopMRUProfiles(int p_10978_) {
        return ImmutableList.copyOf(this.profilesByUUID.values()).stream().sorted(Comparator.comparing(GameProfileInfo::getLastAccess).reversed()).limit(p_10978_);
    }

    private static JsonElement writeGameProfile(GameProfileInfo p_10982_, DateFormat p_10983_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", p_10982_.getProfile().getName());
        UUID uuid = p_10982_.getProfile().getId();
        jsonobject.addProperty("uuid", uuid == null ? "" : uuid.toString());
        jsonobject.addProperty("expiresOn", p_10983_.format(p_10982_.getExpirationDate()));
        return jsonobject;
    }

    private static Optional<GameProfileInfo> readGameProfile(JsonElement p_10989_, DateFormat p_10990_) {
        if (p_10989_.isJsonObject()) {
            JsonObject jsonobject = p_10989_.getAsJsonObject();
            JsonElement jsonelement = jsonobject.get("name");
            JsonElement jsonelement1 = jsonobject.get("uuid");
            JsonElement jsonelement2 = jsonobject.get("expiresOn");
            if (jsonelement != null && jsonelement1 != null) {
                String s = jsonelement1.getAsString();
                String s1 = jsonelement.getAsString();
                Date date = null;
                if (jsonelement2 != null) {
                    try {
                        date = p_10990_.parse(jsonelement2.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (s1 != null && s != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(s);
                    }
                    catch (Throwable throwable) {
                        return Optional.empty();
                    }
                    return Optional.of(new GameProfileInfo(new GameProfile(uuid, s1), date));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static class GameProfileInfo {
        private final GameProfile profile;
        final Date expirationDate;
        private volatile long lastAccess;

        GameProfileInfo(GameProfile p_11022_, Date p_11023_) {
            this.profile = p_11022_;
            this.expirationDate = p_11023_;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long p_11030_) {
            this.lastAccess = p_11030_;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }
    }
}

