/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.players.BanListEntry;

public class UserBanListEntry
extends BanListEntry<GameProfile> {
    public UserBanListEntry(GameProfile p_11436_) {
        this(p_11436_, (Date)null, (String)null, (Date)null, (String)null);
    }

    public UserBanListEntry(GameProfile p_11438_, @Nullable Date p_11439_, @Nullable String p_11440_, @Nullable Date p_11441_, @Nullable String p_11442_) {
        super(p_11438_, p_11439_, p_11440_, p_11441_, p_11442_);
    }

    public UserBanListEntry(JsonObject p_11434_) {
        super(UserBanListEntry.createGameProfile(p_11434_), p_11434_);
    }

    @Override
    protected void serialize(JsonObject pData) {
        if (this.getUser() != null) {
            pData.addProperty("uuid", ((GameProfile)this.getUser()).getId() == null ? "" : ((GameProfile)this.getUser()).getId().toString());
            pData.addProperty("name", ((GameProfile)this.getUser()).getName());
            super.serialize(pData);
        }
    }

    @Override
    public Component getDisplayName() {
        GameProfile gameprofile = (GameProfile)this.getUser();
        return new TextComponent(gameprofile.getName() != null ? gameprofile.getName() : Objects.toString(gameprofile.getId(), "(Unknown)"));
    }

    private static GameProfile createGameProfile(JsonObject pJson) {
        if (pJson.has("uuid") && pJson.has("name")) {
            UUID uuid;
            String s = pJson.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(s);
            }
            catch (Throwable throwable) {
                return null;
            }
            return new GameProfile(uuid, pJson.get("name").getAsString());
        }
        return null;
    }
}

