/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.rcon.NetworkDataOutputStream;
import net.minecraft.server.rcon.PktUtils;
import net.minecraft.server.rcon.thread.GenericThread;
import org.slf4j.Logger;

public class QueryThreadGs4
extends GenericThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String GAME_TYPE = "SMP";
    private static final String GAME_ID = "MINECRAFT";
    private static final long CHALLENGE_CHECK_INTERVAL = 30000L;
    private static final long RESPONSE_CACHE_TIME = 5000L;
    private long lastChallengeCheck;
    private final int port;
    private final int serverPort;
    private final int maxPlayers;
    private final String serverName;
    private final String worldName;
    private DatagramSocket socket;
    private final byte[] buffer = new byte[1460];
    private String hostIp;
    private String serverIp;
    private final Map<SocketAddress, RequestChallenge> validChallenges;
    private final NetworkDataOutputStream rulesResponse;
    private long lastRulesResponse;
    private final ServerInterface serverInterface;

    private QueryThreadGs4(ServerInterface p_11541_, int p_11542_) {
        super("Query Listener");
        this.serverInterface = p_11541_;
        this.port = p_11542_;
        this.serverIp = p_11541_.getServerIp();
        this.serverPort = p_11541_.getServerPort();
        this.serverName = p_11541_.getServerName();
        this.maxPlayers = p_11541_.getMaxPlayers();
        this.worldName = p_11541_.getLevelIdName();
        this.lastRulesResponse = 0L;
        this.hostIp = "0.0.0.0";
        if (!this.serverIp.isEmpty() && !this.hostIp.equals(this.serverIp)) {
            this.hostIp = this.serverIp;
        } else {
            this.serverIp = "0.0.0.0";
            try {
                InetAddress inetaddress = InetAddress.getLocalHost();
                this.hostIp = inetaddress.getHostAddress();
            }
            catch (UnknownHostException unknownhostexception) {
                LOGGER.warn("Unable to determine local host IP, please set server-ip in server.properties", (Throwable)unknownhostexception);
            }
        }
        this.rulesResponse = new NetworkDataOutputStream(1460);
        this.validChallenges = Maps.newHashMap();
    }

    @Nullable
    public static QueryThreadGs4 create(ServerInterface p_11554_) {
        int i = p_11554_.getProperties().queryPort;
        if (i > 0 && 65535 >= i) {
            QueryThreadGs4 querythreadgs4 = new QueryThreadGs4(p_11554_, i);
            return !querythreadgs4.start() ? null : querythreadgs4;
        }
        LOGGER.warn("Invalid query port {} found in server.properties (queries disabled)", (Object)i);
        return null;
    }

    private void a(byte[] p_11556_, DatagramPacket p_11557_) throws IOException {
        this.socket.send(new DatagramPacket(p_11556_, p_11556_.length, p_11557_.getSocketAddress()));
    }

    private boolean processPacket(DatagramPacket pRequestPacket) throws IOException {
        byte[] abyte = pRequestPacket.getData();
        int i = pRequestPacket.getLength();
        SocketAddress socketaddress = pRequestPacket.getSocketAddress();
        LOGGER.debug("Packet len {} [{}]", (Object)i, (Object)socketaddress);
        if (3 <= i && -2 == abyte[0] && -3 == abyte[1]) {
            LOGGER.debug("Packet '{}' [{}]", (Object)PktUtils.toHexString(abyte[2]), (Object)socketaddress);
            switch (abyte[2]) {
                case 0: {
                    if (!this.validChallenge(pRequestPacket).booleanValue()) {
                        LOGGER.debug("Invalid challenge [{}]", (Object)socketaddress);
                        return false;
                    }
                    if (15 == i) {
                        this.a(this.buildRuleResponse(pRequestPacket), pRequestPacket);
                        LOGGER.debug("Rules [{}]", (Object)socketaddress);
                    } else {
                        NetworkDataOutputStream networkdataoutputstream = new NetworkDataOutputStream(1460);
                        networkdataoutputstream.write(0);
                        networkdataoutputstream.a(this.getIdentBytes(pRequestPacket.getSocketAddress()));
                        networkdataoutputstream.writeString(this.serverName);
                        networkdataoutputstream.writeString(GAME_TYPE);
                        networkdataoutputstream.writeString(this.worldName);
                        networkdataoutputstream.writeString(Integer.toString(this.serverInterface.getPlayerCount()));
                        networkdataoutputstream.writeString(Integer.toString(this.maxPlayers));
                        networkdataoutputstream.writeShort((short)this.serverPort);
                        networkdataoutputstream.writeString(this.hostIp);
                        this.a(networkdataoutputstream.toByteArray(), pRequestPacket);
                        LOGGER.debug("Status [{}]", (Object)socketaddress);
                    }
                }
                default: {
                    return true;
                }
                case 9: 
            }
            this.sendChallenge(pRequestPacket);
            LOGGER.debug("Challenge [{}]", (Object)socketaddress);
            return true;
        }
        LOGGER.debug("Invalid packet [{}]", (Object)socketaddress);
        return false;
    }

    private byte[] buildRuleResponse(DatagramPacket pRequestPacket) throws IOException {
        String[] astring;
        long i = Util.getMillis();
        if (i < this.lastRulesResponse + 5000L) {
            byte[] abyte = this.rulesResponse.toByteArray();
            byte[] abyte1 = this.getIdentBytes(pRequestPacket.getSocketAddress());
            abyte[1] = abyte1[0];
            abyte[2] = abyte1[1];
            abyte[3] = abyte1[2];
            abyte[4] = abyte1[3];
            return abyte;
        }
        this.lastRulesResponse = i;
        this.rulesResponse.reset();
        this.rulesResponse.write(0);
        this.rulesResponse.a(this.getIdentBytes(pRequestPacket.getSocketAddress()));
        this.rulesResponse.writeString("splitnum");
        this.rulesResponse.write(128);
        this.rulesResponse.write(0);
        this.rulesResponse.writeString("hostname");
        this.rulesResponse.writeString(this.serverName);
        this.rulesResponse.writeString("gametype");
        this.rulesResponse.writeString(GAME_TYPE);
        this.rulesResponse.writeString("game_id");
        this.rulesResponse.writeString(GAME_ID);
        this.rulesResponse.writeString("version");
        this.rulesResponse.writeString(this.serverInterface.getServerVersion());
        this.rulesResponse.writeString("plugins");
        this.rulesResponse.writeString(this.serverInterface.getPluginNames());
        this.rulesResponse.writeString("map");
        this.rulesResponse.writeString(this.worldName);
        this.rulesResponse.writeString("numplayers");
        this.rulesResponse.writeString("" + this.serverInterface.getPlayerCount());
        this.rulesResponse.writeString("maxplayers");
        this.rulesResponse.writeString("" + this.maxPlayers);
        this.rulesResponse.writeString("hostport");
        this.rulesResponse.writeString("" + this.serverPort);
        this.rulesResponse.writeString("hostip");
        this.rulesResponse.writeString(this.hostIp);
        this.rulesResponse.write(0);
        this.rulesResponse.write(1);
        this.rulesResponse.writeString("player_");
        this.rulesResponse.write(0);
        String[] stringArray = astring = this.serverInterface.getPlayerNames();
        int n = astring.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.rulesResponse.writeString(s);
            ++n2;
        }
        this.rulesResponse.write(0);
        return this.rulesResponse.toByteArray();
    }

    private byte[] getIdentBytes(SocketAddress pAddress) {
        return this.validChallenges.get(pAddress).getIdentBytes();
    }

    private Boolean validChallenge(DatagramPacket pRequestPacket) {
        SocketAddress socketaddress = pRequestPacket.getSocketAddress();
        if (!this.validChallenges.containsKey(socketaddress)) {
            return false;
        }
        byte[] abyte = pRequestPacket.getData();
        if (this.validChallenges.get(socketaddress).getChallenge() == PktUtils.c(abyte, 7, pRequestPacket.getLength())) {
            return true;
        }
        return false;
    }

    private void sendChallenge(DatagramPacket pRequestPacket) throws IOException {
        RequestChallenge querythreadgs4$requestchallenge = new RequestChallenge(pRequestPacket);
        this.validChallenges.put(pRequestPacket.getSocketAddress(), querythreadgs4$requestchallenge);
        this.a(querythreadgs4$requestchallenge.getChallengeBytes(), pRequestPacket);
    }

    private void pruneChallenges() {
        long i;
        if (this.running && (i = Util.getMillis()) >= this.lastChallengeCheck + 30000L) {
            this.lastChallengeCheck = i;
            this.validChallenges.values().removeIf(p_11546_ -> p_11546_.before(i));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean start() {
        if (this.running) {
            return true;
        }
        return !this.initSocket() ? false : super.start();
    }

    private void recoverSocketError(Exception pException) {
        if (this.running) {
            LOGGER.warn("Unexpected exception", (Throwable)pException);
            if (!this.initSocket()) {
                LOGGER.error("Failed to recover from exception, shutting down!");
                this.running = false;
            }
        }
    }

    private boolean initSocket() {
        try {
            this.socket = new DatagramSocket(this.port, InetAddress.getByName(this.serverIp));
            this.socket.setSoTimeout(500);
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to initialise query system on {}:{}", new Object[]{this.serverIp, this.port, exception});
            return false;
        }
    }

    static class RequestChallenge {
        private final long time = new Date().getTime();
        private final int challenge;
        private final byte[] identBytes;
        private final byte[] challengeBytes;
        private final String ident;

        public RequestChallenge(DatagramPacket p_11573_) {
            byte[] abyte = p_11573_.getData();
            this.identBytes = new byte[4];
            this.identBytes[0] = abyte[3];
            this.identBytes[1] = abyte[4];
            this.identBytes[2] = abyte[5];
            this.identBytes[3] = abyte[6];
            this.ident = new String(this.identBytes, StandardCharsets.UTF_8);
            this.challenge = new Random().nextInt(0x1000000);
            this.challengeBytes = String.format("\t%s%d\u0000", this.ident, this.challenge).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean before(long pCurrentTime) {
            if (this.time < pCurrentTime) {
                return true;
            }
            return false;
        }

        public int getChallenge() {
            return this.challenge;
        }

        public byte[] getChallengeBytes() {
            return this.challengeBytes;
        }

        public byte[] getIdentBytes() {
            return this.identBytes;
        }

        public String getIdent() {
            return this.ident;
        }
    }
}

