/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.rcon.thread.GenericThread;
import net.minecraft.server.rcon.thread.RconClient;
import org.slf4j.Logger;

public class RconThread
extends GenericThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerSocket socket;
    private final String rconPassword;
    private final List<RconClient> clients = Lists.newArrayList();
    private final ServerInterface serverInterface;

    private RconThread(ServerInterface p_11608_, ServerSocket p_11609_, String p_11610_) {
        super("RCON Listener");
        this.serverInterface = p_11608_;
        this.socket = p_11609_;
        this.rconPassword = p_11610_;
    }

    private void clearClients() {
        this.clients.removeIf(p_11612_ -> !p_11612_.isRunning());
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static RconThread create(ServerInterface p_11616_) {
        int i;
        DedicatedServerProperties dedicatedserverproperties = p_11616_.getProperties();
        String s = p_11616_.getServerIp();
        if (s.isEmpty()) {
            s = "0.0.0.0";
        }
        if ((i = dedicatedserverproperties.rconPort) > 0 && 65535 >= i) {
            RconThread rconthread;
            block6: {
                String s1 = dedicatedserverproperties.rconPassword;
                if (s1.isEmpty()) {
                    LOGGER.warn("No rcon password set in server.properties, rcon disabled!");
                    return null;
                }
                try {
                    ServerSocket serversocket = new ServerSocket(i, 0, InetAddress.getByName(s));
                    serversocket.setSoTimeout(500);
                    rconthread = new RconThread(p_11616_, serversocket, s1);
                    if (rconthread.start()) break block6;
                    return null;
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Unable to initialise RCON on {}:{}", new Object[]{s, i, ioexception});
                    return null;
                }
            }
            LOGGER.info("RCON running on {}:{}", (Object)s, (Object)i);
            return rconthread;
        }
        LOGGER.warn("Invalid rcon port {} found in server.properties, rcon disabled!", (Object)i);
        return null;
    }

    @Override
    public void stop() {
        this.running = false;
        this.closeSocket(this.socket);
        super.stop();
        for (RconClient rconclient : this.clients) {
            if (!rconclient.isRunning()) continue;
            rconclient.stop();
        }
        this.clients.clear();
    }

    private void closeSocket(ServerSocket p_11614_) {
        LOGGER.debug("closeSocket: {}", (Object)p_11614_);
        try {
            p_11614_.close();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to close socket", (Throwable)ioexception);
        }
    }
}

