/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> pStates) {
        this.states = pStates;
    }

    public RecipeBookSettings() {
        this(Util.make(Maps.newEnumMap(RecipeBookType.class), p_12740_ -> {
            RecipeBookType[] recipeBookTypeArray = RecipeBookType.values();
            int n = recipeBookTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RecipeBookType recipebooktype = recipeBookTypeArray[n2];
                p_12740_.put(recipebooktype, new TypeSettings(false, false));
                ++n2;
            }
        }));
    }

    public boolean isOpen(RecipeBookType pBookType) {
        return this.states.get((Object)((Object)pBookType)).open;
    }

    public void setOpen(RecipeBookType pBookType, boolean pOpen) {
        this.states.get((Object)((Object)pBookType)).open = pOpen;
    }

    public boolean isFiltering(RecipeBookType pBookType) {
        return this.states.get((Object)((Object)pBookType)).filtering;
    }

    public void setFiltering(RecipeBookType pBookType, boolean pFiltering) {
        this.states.get((Object)((Object)pBookType)).filtering = pFiltering;
    }

    public static RecipeBookSettings read(FriendlyByteBuf pTag) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        RecipeBookType[] recipeBookTypeArray = RecipeBookType.values();
        int n = recipeBookTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecipeBookType recipebooktype = recipeBookTypeArray[n2];
            boolean flag = pTag.readBoolean();
            boolean flag1 = pTag.readBoolean();
            map.put(recipebooktype, new TypeSettings(flag, flag1));
            ++n2;
        }
        return new RecipeBookSettings(map);
    }

    public void write(FriendlyByteBuf pTag) {
        RecipeBookType[] recipeBookTypeArray = RecipeBookType.values();
        int n = recipeBookTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecipeBookType recipebooktype = recipeBookTypeArray[n2];
            TypeSettings recipebooksettings$typesettings = this.states.get((Object)recipebooktype);
            if (recipebooksettings$typesettings == null) {
                pTag.writeBoolean(false);
                pTag.writeBoolean(false);
            } else {
                pTag.writeBoolean(recipebooksettings$typesettings.open);
                pTag.writeBoolean(recipebooksettings$typesettings.filtering);
            }
            ++n2;
        }
    }

    public static RecipeBookSettings read(CompoundTag pTag) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        TAG_FIELDS.forEach((p_12750_, p_12751_) -> {
            boolean flag = pTag.getBoolean((String)p_12751_.getFirst());
            boolean flag1 = pTag.getBoolean((String)p_12751_.getSecond());
            map.put(p_12750_, new TypeSettings(flag, flag1));
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag pTag) {
        TAG_FIELDS.forEach((p_12745_, p_12746_) -> {
            TypeSettings recipebooksettings$typesettings = this.states.get(p_12745_);
            pTag.putBoolean((String)p_12746_.getFirst(), recipebooksettings$typesettings.open);
            pTag.putBoolean((String)p_12746_.getSecond(), recipebooksettings$typesettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        RecipeBookType[] recipeBookTypeArray = RecipeBookType.values();
        int n = recipeBookTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecipeBookType recipebooktype = recipeBookTypeArray[n2];
            TypeSettings recipebooksettings$typesettings = this.states.get((Object)recipebooktype);
            map.put(recipebooktype, recipebooksettings$typesettings.copy());
            ++n2;
        }
        return new RecipeBookSettings(map);
    }

    public void replaceFrom(RecipeBookSettings pOther) {
        this.states.clear();
        RecipeBookType[] recipeBookTypeArray = RecipeBookType.values();
        int n = recipeBookTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecipeBookType recipebooktype = recipeBookTypeArray[n2];
            TypeSettings recipebooksettings$typesettings = pOther.states.get((Object)recipebooktype);
            this.states.put(recipebooktype, recipebooksettings$typesettings.copy());
            ++n2;
        }
    }

    public boolean equals(Object pOther) {
        return this == pOther || pOther instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)pOther).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    static final class TypeSettings {
        boolean open;
        boolean filtering;

        public TypeSettings(boolean pOpen, boolean pFiltering) {
            this.open = pOpen;
            this.filtering = pFiltering;
        }

        public TypeSettings copy() {
            return new TypeSettings(this.open, this.filtering);
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (!(pOther instanceof TypeSettings)) {
                return false;
            }
            TypeSettings recipebooksettings$typesettings = (TypeSettings)pOther;
            return this.open == recipebooksettings$typesettings.open && this.filtering == recipebooksettings$typesettings.filtering;
        }

        public int hashCode() {
            int i = this.open ? 1 : 0;
            return 31 * i + (this.filtering ? 1 : 0);
        }

        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }
    }
}

