/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftServer server;
    private final File file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    public ServerStatsCounter(MinecraftServer pServer, File pFile) {
        this.server = pServer;
        this.file = pFile;
        if (pFile.isFile()) {
            try {
                this.parseLocal(pServer.getFixerUpper(), FileUtils.readFileToString((File)pFile));
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't read statistics file {}", (Object)pFile, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)pFile, (Object)jsonparseexception);
            }
        }
    }

    public void save() {
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void setValue(Player pPlayer, Stat<?> pStat, int pValue) {
        super.setValue(pPlayer, pStat, pValue);
        this.dirty.add(pStat);
    }

    private Set<Stat<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parseLocal(DataFixer pFixerUpper, String pJson) {
        block12: {
            try {
                try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(pJson));){
                    jsonreader.setLenient(false);
                    JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                    if (!jsonelement.isJsonNull()) {
                        CompoundTag compoundtag = ServerStatsCounter.fromJson(jsonelement.getAsJsonObject());
                        if (!compoundtag.contains("DataVersion", 99)) {
                            compoundtag.putInt("DataVersion", 1343);
                        }
                        if (!(compoundtag = NbtUtils.update(pFixerUpper, DataFixTypes.STATS, compoundtag, compoundtag.getInt("DataVersion"))).contains("stats", 10)) {
                            break block12;
                        }
                        CompoundTag compoundtag1 = compoundtag.getCompound("stats");
                        Iterator<String> iterator = compoundtag1.getAllKeys().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block12;
                            }
                            String s = iterator.next();
                            if (!compoundtag1.contains(s, 10)) continue;
                            Util.ifElse(Registry.STAT_TYPE.getOptional(new ResourceLocation(s)), p_12844_ -> {
                                CompoundTag compoundtag2 = compoundtag1.getCompound(s);
                                for (String s1 : compoundtag2.getAllKeys()) {
                                    if (compoundtag2.contains(s1, 99)) {
                                        Util.ifElse(this.getStat((StatType)p_12844_, s1), p_144252_ -> this.stats.put(p_144252_, compoundtag2.getInt(s1)), () -> LOGGER.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.file, (Object)s1));
                                        continue;
                                    }
                                    LOGGER.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.file, compoundtag2.get(s1), s1});
                                }
                            }, () -> LOGGER.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.file, (Object)s));
                        }
                    }
                    LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                }
                return;
            }
            catch (JsonParseException | IOException jsonparseexception) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)jsonparseexception);
            }
        }
    }

    private <T> Optional<Stat<T>> getStat(StatType<T> pType, String pLocation) {
        return Optional.ofNullable(ResourceLocation.tryParse(pLocation)).flatMap(pType.getRegistry()::getOptional).map(pType::get);
    }

    private static CompoundTag fromJson(JsonObject pJson) {
        CompoundTag compoundtag = new CompoundTag();
        for (Map.Entry entry : pJson.entrySet()) {
            JsonPrimitive jsonprimitive;
            JsonElement jsonelement = (JsonElement)entry.getValue();
            if (jsonelement.isJsonObject()) {
                compoundtag.put((String)entry.getKey(), ServerStatsCounter.fromJson(jsonelement.getAsJsonObject()));
                continue;
            }
            if (!jsonelement.isJsonPrimitive() || !(jsonprimitive = jsonelement.getAsJsonPrimitive()).isNumber()) continue;
            compoundtag.putInt((String)entry.getKey(), jsonprimitive.getAsInt());
        }
        return compoundtag;
    }

    protected String toJson() {
        HashMap map = Maps.newHashMap();
        for (Object2IntMap.Entry entry : this.stats.object2IntEntrySet()) {
            Stat stat = (Stat)entry.getKey();
            map.computeIfAbsent(stat.getType(), p_12822_ -> new JsonObject()).addProperty(ServerStatsCounter.getKey(stat).toString(), (Number)entry.getIntValue());
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry entry1 : map.entrySet()) {
            jsonobject.add(Registry.STAT_TYPE.getKey((StatType)entry1.getKey()).toString(), (JsonElement)entry1.getValue());
        }
        JsonObject jsonobject1 = new JsonObject();
        jsonobject1.add("stats", (JsonElement)jsonobject);
        jsonobject1.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getWorldVersion());
        return jsonobject1.toString();
    }

    private static <T> ResourceLocation getKey(Stat<T> pStat) {
        return pStat.getType().getRegistry().getKey(pStat.getValue());
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer pPlayer) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Stat<?> stat : this.getDirty()) {
            object2intmap.put(stat, this.getValue(stat));
        }
        pPlayer.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)object2intmap));
    }
}

