/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.Util;

public interface StatFormatter {
    public static final DecimalFormat DECIMAL_FORMAT = Util.make(new DecimalFormat("########0.00"), p_12881_ -> p_12881_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final StatFormatter DEFAULT = NumberFormat.getIntegerInstance(Locale.US)::format;
    public static final StatFormatter DIVIDE_BY_TEN = p_12885_ -> DECIMAL_FORMAT.format((double)p_12885_ * 0.1);
    public static final StatFormatter DISTANCE = p_12883_ -> {
        double d0 = (double)p_12883_ / 100.0;
        double d1 = d0 / 1000.0;
        if (d1 > 0.5) {
            return String.valueOf(DECIMAL_FORMAT.format(d1)) + " km";
        }
        return d0 > 0.5 ? String.valueOf(DECIMAL_FORMAT.format(d0)) + " m" : String.valueOf(p_12883_) + " cm";
    };
    public static final StatFormatter TIME = p_12879_ -> {
        double d0 = (double)p_12879_ / 20.0;
        double d1 = d0 / 60.0;
        double d2 = d1 / 60.0;
        double d3 = d2 / 24.0;
        double d4 = d3 / 365.0;
        if (d4 > 0.5) {
            return String.valueOf(DECIMAL_FORMAT.format(d4)) + " y";
        }
        if (d3 > 0.5) {
            return String.valueOf(DECIMAL_FORMAT.format(d3)) + " d";
        }
        if (d2 > 0.5) {
            return String.valueOf(DECIMAL_FORMAT.format(d2)) + " h";
        }
        return d1 > 0.5 ? String.valueOf(DECIMAL_FORMAT.format(d1)) + " m" : String.valueOf(d0) + " s";
    };

    public String format(int var1);
}

