/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class Tag<T> {
    private static final Tag<?> EMPTY = new Tag(List.of());
    final List<T> elements;

    public Tag(Collection<T> p_203860_) {
        this.elements = List.copyOf(p_203860_);
    }

    public List<T> getValues() {
        return this.elements;
    }

    public static <T> Tag<T> empty() {
        return EMPTY;
    }

    public static class Builder {
        private final List<BuilderEntry> entries = new ArrayList<BuilderEntry>();

        public static Builder tag() {
            return new Builder();
        }

        public Builder add(BuilderEntry pEntry) {
            this.entries.add(pEntry);
            return this;
        }

        public Builder add(Entry pEntry, String pSource) {
            return this.add(new BuilderEntry(pEntry, pSource));
        }

        public Builder addElement(ResourceLocation pId, String pSource) {
            return this.add(new ElementEntry(pId), pSource);
        }

        public Builder addOptionalElement(ResourceLocation pId, String pSource) {
            return this.add(new OptionalElementEntry(pId), pSource);
        }

        public Builder addTag(ResourceLocation pId, String pSource) {
            return this.add(new TagEntry(pId), pSource);
        }

        public Builder addOptionalTag(ResourceLocation pId, String pSource) {
            return this.add(new OptionalTagEntry(pId), pSource);
        }

        public <T> Either<Collection<BuilderEntry>, Tag<T>> build(Function<ResourceLocation, Tag<T>> pTagFunction, Function<ResourceLocation, T> pValueFunction) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ArrayList<BuilderEntry> list = new ArrayList<BuilderEntry>();
            for (BuilderEntry tag$builderentry : this.entries) {
                if (tag$builderentry.entry().build(pTagFunction, pValueFunction, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
                list.add(tag$builderentry);
            }
            return list.isEmpty() ? Either.right(new Tag(builder.build())) : Either.left(list);
        }

        public Stream<BuilderEntry> getEntries() {
            return this.entries.stream();
        }

        public void visitRequiredDependencies(Consumer<ResourceLocation> pVisitor) {
            this.entries.forEach(p_144378_ -> p_144378_.entry.visitRequiredDependencies(pVisitor));
        }

        public void visitOptionalDependencies(Consumer<ResourceLocation> pVisitor) {
            this.entries.forEach(p_144370_ -> p_144370_.entry.visitOptionalDependencies(pVisitor));
        }

        public Builder addFromJson(JsonObject pJson, String pSource) {
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, "values");
            ArrayList<Entry> list = new ArrayList<Entry>();
            for (JsonElement jsonelement : jsonarray) {
                list.add(Builder.parseEntry(jsonelement));
            }
            if (GsonHelper.getAsBoolean(pJson, "replace", false)) {
                this.entries.clear();
            }
            list.forEach(p_13319_ -> this.entries.add(new BuilderEntry((Entry)p_13319_, pSource)));
            return this;
        }

        private static Entry parseEntry(JsonElement pJson) {
            boolean flag;
            String s;
            if (pJson.isJsonObject()) {
                JsonObject jsonobject = pJson.getAsJsonObject();
                s = GsonHelper.getAsString(jsonobject, "id");
                flag = GsonHelper.getAsBoolean(jsonobject, "required", true);
            } else {
                s = GsonHelper.convertToString(pJson, "id");
                flag = true;
            }
            if (s.startsWith("#")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(s.substring(1));
                return flag ? new TagEntry(resourcelocation1) : new OptionalTagEntry(resourcelocation1);
            }
            ResourceLocation resourcelocation = new ResourceLocation(s);
            return flag ? new ElementEntry(resourcelocation) : new OptionalElementEntry(resourcelocation);
        }

        public JsonObject serializeToJson() {
            JsonObject jsonobject = new JsonObject();
            JsonArray jsonarray = new JsonArray();
            for (BuilderEntry tag$builderentry : this.entries) {
                tag$builderentry.entry().serializeTo(jsonarray);
            }
            jsonobject.addProperty("replace", Boolean.valueOf(false));
            jsonobject.add("values", (JsonElement)jsonarray);
            return jsonobject;
        }
    }

    public record BuilderEntry(Entry entry, String source) {
        @Override
        public String toString() {
            return this.entry + " (from " + this.source + ")";
        }
    }

    static class ElementEntry
    implements Entry {
        private final ResourceLocation id;

        public ElementEntry(ResourceLocation pId) {
            this.id = pId;
        }

        @Override
        public <T> boolean build(Function<ResourceLocation, Tag<T>> pResourceTagFunction, Function<ResourceLocation, T> pResourceElementFunction, Consumer<T> pElementConsumer) {
            T t = pResourceElementFunction.apply(this.id);
            if (t == null) {
                return false;
            }
            pElementConsumer.accept(t);
            return true;
        }

        @Override
        public void serializeTo(JsonArray pJsonArray) {
            pJsonArray.add(this.id.toString());
        }

        @Override
        public boolean verifyIfPresent(Predicate<ResourceLocation> pRegistryPredicate, Predicate<ResourceLocation> pBuilderPredicate) {
            return pRegistryPredicate.test(this.id);
        }

        public String toString() {
            return this.id.toString();
        }
    }

    public static interface Entry {
        public <T> boolean build(Function<ResourceLocation, Tag<T>> var1, Function<ResourceLocation, T> var2, Consumer<T> var3);

        public void serializeTo(JsonArray var1);

        default public void visitRequiredDependencies(Consumer<ResourceLocation> pVisitor) {
        }

        default public void visitOptionalDependencies(Consumer<ResourceLocation> pVisitor) {
        }

        public boolean verifyIfPresent(Predicate<ResourceLocation> var1, Predicate<ResourceLocation> var2);
    }

    static class OptionalElementEntry
    implements Entry {
        private final ResourceLocation id;

        public OptionalElementEntry(ResourceLocation pId) {
            this.id = pId;
        }

        @Override
        public <T> boolean build(Function<ResourceLocation, Tag<T>> pResourceTagFunction, Function<ResourceLocation, T> pResourceElementFunction, Consumer<T> pElementConsumer) {
            T t = pResourceElementFunction.apply(this.id);
            if (t != null) {
                pElementConsumer.accept(t);
            }
            return true;
        }

        @Override
        public void serializeTo(JsonArray pJsonArray) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", this.id.toString());
            jsonobject.addProperty("required", Boolean.valueOf(false));
            pJsonArray.add((JsonElement)jsonobject);
        }

        @Override
        public boolean verifyIfPresent(Predicate<ResourceLocation> pRegistryPredicate, Predicate<ResourceLocation> pBuilderPredicate) {
            return true;
        }

        public String toString() {
            return this.id + "?";
        }
    }

    static class OptionalTagEntry
    implements Entry {
        private final ResourceLocation id;

        public OptionalTagEntry(ResourceLocation pId) {
            this.id = pId;
        }

        @Override
        public <T> boolean build(Function<ResourceLocation, Tag<T>> pResourceTagFunction, Function<ResourceLocation, T> pResourceElementFunction, Consumer<T> pElementConsumer) {
            Tag<T> tag = pResourceTagFunction.apply(this.id);
            if (tag != null) {
                tag.elements.forEach(pElementConsumer);
            }
            return true;
        }

        @Override
        public void serializeTo(JsonArray pJsonArray) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", "#" + this.id);
            jsonobject.addProperty("required", Boolean.valueOf(false));
            pJsonArray.add((JsonElement)jsonobject);
        }

        public String toString() {
            return "#" + this.id + "?";
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> pVisitor) {
            pVisitor.accept(this.id);
        }

        @Override
        public boolean verifyIfPresent(Predicate<ResourceLocation> pRegistryPredicate, Predicate<ResourceLocation> pBuilderPredicate) {
            return true;
        }
    }

    static class TagEntry
    implements Entry {
        private final ResourceLocation id;

        public TagEntry(ResourceLocation pId) {
            this.id = pId;
        }

        @Override
        public <T> boolean build(Function<ResourceLocation, Tag<T>> pResourceTagFunction, Function<ResourceLocation, T> pResourceElementFunction, Consumer<T> pElementConsumer) {
            Tag<T> tag = pResourceTagFunction.apply(this.id);
            if (tag == null) {
                return false;
            }
            tag.elements.forEach(pElementConsumer);
            return true;
        }

        @Override
        public void serializeTo(JsonArray pJsonArray) {
            pJsonArray.add("#" + this.id);
        }

        public String toString() {
            return "#" + this.id;
        }

        @Override
        public boolean verifyIfPresent(Predicate<ResourceLocation> pRegistryPredicate, Predicate<ResourceLocation> pBuilderPredicate) {
            return pBuilderPredicate.test(this.id);
        }

        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> pVisitor) {
            pVisitor.accept(this.id);
        }
    }
}

