/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Function<ResourceLocation, Optional<T>> idToValue;
    private final String directory;

    public TagLoader(Function<ResourceLocation, Optional<T>> pIdToValue, String pDirectory) {
        this.idToValue = pIdToValue;
        this.directory = pDirectory;
    }

    public Map<ResourceLocation, Tag.Builder> load(ResourceManager pResourceManager) {
        HashMap map = Maps.newHashMap();
        for (ResourceLocation resourcelocation : pResourceManager.listResources(this.directory, p_144506_ -> p_144506_.endsWith(PATH_SUFFIX))) {
            String s = resourcelocation.getPath();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.getNamespace(), s.substring(this.directory.length() + 1, s.length() - PATH_SUFFIX_LENGTH));
            try {
                for (Resource resource : pResourceManager.getResources(resourcelocation)) {
                    try {
                        try (InputStream inputstream = resource.getInputStream();
                             BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            JsonObject jsonobject = GsonHelper.fromJson(GSON, (Reader)reader, JsonObject.class);
                            if (jsonobject == null) {
                                LOGGER.error("Couldn't load tag list {} from {} in data pack {} as it is empty or null", new Object[]{resourcelocation1, resourcelocation, resource.getSourceName()});
                            } else {
                                map.computeIfAbsent(resourcelocation1, p_144555_ -> Tag.Builder.tag()).addFromJson(jsonobject, resource.getSourceName());
                            }
                        }
                        catch (IOException | RuntimeException ioexception) {
                            LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourcelocation1, resourcelocation, resource.getSourceName(), ioexception});
                            IOUtils.closeQuietly((Closeable)resource);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((Closeable)resource);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
            catch (IOException ioexception1) {
                LOGGER.error("Couldn't read tag list {} from {}", new Object[]{resourcelocation1, resourcelocation, ioexception1});
            }
        }
        return map;
    }

    private static void visitDependenciesAndElement(Map<ResourceLocation, Tag.Builder> pBuilders, Multimap<ResourceLocation, ResourceLocation> pDependencyNames, Set<ResourceLocation> pNames, ResourceLocation pName, BiConsumer<ResourceLocation, Tag.Builder> pVisitor) {
        if (pNames.add(pName)) {
            pDependencyNames.get((Object)pName).forEach(p_144514_ -> TagLoader.visitDependenciesAndElement(pBuilders, pDependencyNames, pNames, p_144514_, pVisitor));
            Tag.Builder tag$builder = pBuilders.get(pName);
            if (tag$builder != null) {
                pVisitor.accept(pName, tag$builder);
            }
        }
    }

    private static boolean isCyclic(Multimap<ResourceLocation, ResourceLocation> pDependencyNames, ResourceLocation pName, ResourceLocation pDependencyName) {
        Collection collection = pDependencyNames.get((Object)pDependencyName);
        return collection.contains(pName) ? true : collection.stream().anyMatch(p_144567_ -> TagLoader.isCyclic(pDependencyNames, pName, p_144567_));
    }

    private static void addDependencyIfNotCyclic(Multimap<ResourceLocation, ResourceLocation> pDependencyNames, ResourceLocation pName, ResourceLocation pDependencyName) {
        if (!TagLoader.isCyclic(pDependencyNames, pName, pDependencyName)) {
            pDependencyNames.put((Object)pName, (Object)pDependencyName);
        }
    }

    public Map<ResourceLocation, Tag<T>> build(Map<ResourceLocation, Tag.Builder> pBuilders) {
        HashMap map = Maps.newHashMap();
        Function<ResourceLocation, Tag> function = map::get;
        Function<ResourceLocation, Object> function1 = p_144540_ -> this.idToValue.apply((ResourceLocation)p_144540_).orElse(null);
        HashMultimap multimap = HashMultimap.create();
        pBuilders.forEach((arg_0, arg_1) -> TagLoader.lambda$6((Multimap)multimap, arg_0, arg_1));
        pBuilders.forEach((arg_0, arg_1) -> TagLoader.lambda$8((Multimap)multimap, arg_0, arg_1));
        HashSet set = Sets.newHashSet();
        pBuilders.keySet().forEach(arg_0 -> TagLoader.lambda$10(pBuilders, (Multimap)multimap, set, function, function1, map, arg_0));
        return map;
    }

    public Map<ResourceLocation, Tag<T>> loadAndBuild(ResourceManager pResourceManager) {
        return this.build(this.load(pResourceManager));
    }

    private static /* synthetic */ void lambda$6(Multimap multimap, ResourceLocation p_144548_, Tag.Builder p_144549_) {
        p_144549_.visitRequiredDependencies(p_144563_ -> TagLoader.addDependencyIfNotCyclic((Multimap<ResourceLocation, ResourceLocation>)multimap, p_144548_, p_144563_));
    }

    private static /* synthetic */ void lambda$8(Multimap multimap, ResourceLocation p_144499_, Tag.Builder p_144500_) {
        p_144500_.visitOptionalDependencies(p_144559_ -> TagLoader.addDependencyIfNotCyclic((Multimap<ResourceLocation, ResourceLocation>)multimap, p_144499_, p_144559_));
    }

    private static /* synthetic */ void lambda$10(Map map, Multimap multimap, Set set, Function function, Function function2, Map map2, ResourceLocation p_144522_) {
        TagLoader.visitDependenciesAndElement(map, (Multimap<ResourceLocation, ResourceLocation>)multimap, set, p_144522_, (p_144537_, p_144538_) -> p_144538_.build(function, function2).ifLeft(p_144543_ -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", p_144537_, (Object)p_144543_.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(p_144532_ -> map2.put(p_144537_, p_144532_)));
    }
}

