/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;

public class TagManager
implements PreparableReloadListener {
    private static final Map<ResourceKey<? extends Registry<?>>, String> CUSTOM_REGISTRY_DIRECTORIES = Map.of(Registry.BLOCK_REGISTRY, "tags/blocks", Registry.ENTITY_TYPE_REGISTRY, "tags/entity_types", Registry.FLUID_REGISTRY, "tags/fluids", Registry.GAME_EVENT_REGISTRY, "tags/game_events", Registry.ITEM_REGISTRY, "tags/items");
    private final RegistryAccess registryAccess;
    private List<LoadResult<?>> results = List.of();

    public TagManager(RegistryAccess pRegistryAccess) {
        this.registryAccess = pRegistryAccess;
    }

    public List<LoadResult<?>> getResult() {
        return this.results;
    }

    public static String getTagDir(ResourceKey<? extends Registry<?>> p_203919_) {
        String s = CUSTOM_REGISTRY_DIRECTORIES.get(p_203919_);
        return s != null ? s : "tags/" + p_203919_.location().getPath();
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier pStage, ResourceManager pResourceManager, ProfilerFiller pPreparationsProfiler, ProfilerFiller pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
        List<CompletableFuture> list = this.registryAccess.registries().map(p_203927_ -> this.createLoader(pResourceManager, pBackgroundExecutor, (RegistryAccess.RegistryEntry)p_203927_)).toList();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new)).thenCompose(pStage::wait)).thenAcceptAsync(p_203917_ -> {
            this.results = list.stream().map(CompletableFuture::join).collect(Collectors.toUnmodifiableList());
        }, pGameExecutor);
    }

    private <T> CompletableFuture<LoadResult<T>> createLoader(ResourceManager pResourceManager, Executor pBackgroundExecutor, RegistryAccess.RegistryEntry<T> pHelper) {
        ResourceKey resourcekey = pHelper.key();
        Registry registry = pHelper.value();
        TagLoader tagloader = new TagLoader(p_203914_ -> registry.getHolder(ResourceKey.create(resourcekey, p_203914_)), TagManager.getTagDir(resourcekey));
        return CompletableFuture.supplyAsync(() -> new LoadResult(resourcekey, tagloader.loadAndBuild(pResourceManager)), pBackgroundExecutor);
    }

    public record LoadResult<T>(ResourceKey<? extends Registry<T>> key, Map<ResourceLocation, Tag<Holder<T>>> tags) {
    }
}

