/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.util.Mth;

public class CrudeIncrementalIntIdentityHashBiMap<K>
implements IdMap<K> {
    private static final int NOT_FOUND = -1;
    private static final Object EMPTY_SLOT = null;
    private static final float LOADFACTOR = 0.8f;
    private K[] keys;
    private int[] values;
    private K[] byId;
    private int nextId;
    private int size;

    private CrudeIncrementalIntIdentityHashBiMap(int p_13553_) {
        this.keys = new Object[p_13553_];
        this.values = new int[p_13553_];
        this.byId = new Object[p_13553_];
    }

    private CrudeIncrementalIntIdentityHashBiMap(K[] p_199841_, int[] p_199842_, K[] p_199843_, int p_199844_, int p_199845_) {
        this.keys = p_199841_;
        this.values = p_199842_;
        this.byId = p_199843_;
        this.nextId = p_199844_;
        this.size = p_199845_;
    }

    public static <A> CrudeIncrementalIntIdentityHashBiMap<A> create(int p_184238_) {
        return new CrudeIncrementalIntIdentityHashBiMap((int)((float)p_184238_ / 0.8f));
    }

    @Override
    public int getId(@Nullable K pValue) {
        return this.getValue(this.indexOf(pValue, this.hash(pValue)));
    }

    @Override
    @Nullable
    public K byId(int pValue) {
        return pValue >= 0 && pValue < this.byId.length ? (K)this.byId[pValue] : null;
    }

    private int getValue(int pKey) {
        return pKey == -1 ? -1 : this.values[pKey];
    }

    public boolean contains(K pValue) {
        return this.getId(pValue) != -1;
    }

    public boolean contains(int pValue) {
        return this.byId(pValue) != null;
    }

    public int add(K pObject) {
        int i = this.nextId();
        this.addMapping(pObject, i);
        return i;
    }

    private int nextId() {
        while (this.nextId < this.byId.length && this.byId[this.nextId] != null) {
            ++this.nextId;
        }
        return this.nextId;
    }

    private void grow(int pCapacity) {
        K[] ak = this.keys;
        int[] aint = this.values;
        CrudeIncrementalIntIdentityHashBiMap<K> crudeincrementalintidentityhashbimap = new CrudeIncrementalIntIdentityHashBiMap<K>(pCapacity);
        int i = 0;
        while (i < ak.length) {
            if (ak[i] != null) {
                crudeincrementalintidentityhashbimap.addMapping(ak[i], aint[i]);
            }
            ++i;
        }
        this.keys = crudeincrementalintidentityhashbimap.keys;
        this.values = crudeincrementalintidentityhashbimap.values;
        this.byId = crudeincrementalintidentityhashbimap.byId;
        this.nextId = crudeincrementalintidentityhashbimap.nextId;
        this.size = crudeincrementalintidentityhashbimap.size;
    }

    public void addMapping(K pObject, int pIntKey) {
        int i = Math.max(pIntKey, this.size + 1);
        if ((float)i >= (float)this.keys.length * 0.8f) {
            int j = this.keys.length << 1;
            while (j < pIntKey) {
                j <<= 1;
            }
            this.grow(j);
        }
        int k = this.findEmpty(this.hash(pObject));
        this.keys[k] = pObject;
        this.values[k] = pIntKey;
        this.byId[pIntKey] = pObject;
        ++this.size;
        if (pIntKey == this.nextId) {
            ++this.nextId;
        }
    }

    private int hash(@Nullable K pObect) {
        return (Mth.murmurHash3Mixer(System.identityHashCode(pObect)) & Integer.MAX_VALUE) % this.keys.length;
    }

    private int indexOf(@Nullable K pObject, int pStartIndex) {
        int i = pStartIndex;
        while (i < this.keys.length) {
            if (this.keys[i] == pObject) {
                return i;
            }
            if (this.keys[i] == EMPTY_SLOT) {
                return -1;
            }
            ++i;
        }
        int j = 0;
        while (j < pStartIndex) {
            if (this.keys[j] == pObject) {
                return j;
            }
            if (this.keys[j] == EMPTY_SLOT) {
                return -1;
            }
            ++j;
        }
        return -1;
    }

    private int findEmpty(int pStartIndex) {
        int i = pStartIndex;
        while (i < this.keys.length) {
            if (this.keys[i] == EMPTY_SLOT) {
                return i;
            }
            ++i;
        }
        int j = 0;
        while (j < pStartIndex) {
            if (this.keys[j] == EMPTY_SLOT) {
                return j;
            }
            ++j;
        }
        throw new RuntimeException("Overflowed :(");
    }

    @Override
    public Iterator<K> iterator() {
        return Iterators.filter((Iterator)Iterators.forArray((Object[])this.byId), (Predicate)Predicates.notNull());
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.byId, null);
        this.nextId = 0;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public CrudeIncrementalIntIdentityHashBiMap<K> copy() {
        return new CrudeIncrementalIntIdentityHashBiMap<Object>((Object[])this.keys.clone(), (int[])this.values.clone(), (Object[])this.byId.clone(), this.nextId, this.size);
    }
}

