/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.util.CryptException;

public class Crypt {
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final int SYMMETRIC_BITS = 128;
    private static final String ASYMMETRIC_ALGORITHM = "RSA";
    private static final int ASYMMETRIC_BITS = 1024;
    private static final String BYTE_ENCODING = "ISO_8859_1";
    private static final String HASH_ALGORITHM = "SHA-1";

    public static SecretKey generateSecretKey() throws CryptException {
        try {
            KeyGenerator keygenerator = KeyGenerator.getInstance(SYMMETRIC_ALGORITHM);
            keygenerator.init(128);
            return keygenerator.generateKey();
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    public static KeyPair generateKeyPair() throws CryptException {
        try {
            KeyPairGenerator keypairgenerator = KeyPairGenerator.getInstance(ASYMMETRIC_ALGORITHM);
            keypairgenerator.initialize(1024);
            return keypairgenerator.generateKeyPair();
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    public static byte[] digestData(String pServerId, PublicKey pPublicKey, SecretKey pSecretKey) throws CryptException {
        try {
            return Crypt.a(pServerId.getBytes(BYTE_ENCODING), pSecretKey.getEncoded(), pPublicKey.getEncoded());
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    private static byte[] a(byte[] ... p_13603_) throws Exception {
        MessageDigest messagedigest = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[][] byArray = p_13603_;
        int n = p_13603_.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] abyte = byArray[n2];
            messagedigest.update(abyte);
            ++n2;
        }
        return messagedigest.digest();
    }

    public static PublicKey a(byte[] p_13601_) throws CryptException {
        try {
            X509EncodedKeySpec encodedkeyspec = new X509EncodedKeySpec(p_13601_);
            KeyFactory keyfactory = KeyFactory.getInstance(ASYMMETRIC_ALGORITHM);
            return keyfactory.generatePublic(encodedkeyspec);
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    public static SecretKey a(PrivateKey p_13598_, byte[] p_13599_) throws CryptException {
        byte[] abyte = Crypt.b(p_13598_, p_13599_);
        try {
            return new SecretKeySpec(abyte, SYMMETRIC_ALGORITHM);
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    public static byte[] a(Key p_13595_, byte[] p_13596_) throws CryptException {
        return Crypt.a(1, p_13595_, p_13596_);
    }

    public static byte[] b(Key p_13606_, byte[] p_13607_) throws CryptException {
        return Crypt.a(2, p_13606_, p_13607_);
    }

    private static byte[] a(int p_13587_, Key p_13588_, byte[] p_13589_) throws CryptException {
        try {
            return Crypt.setupCipher(p_13587_, p_13588_.getAlgorithm(), p_13588_).doFinal(p_13589_);
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    private static Cipher setupCipher(int pOpMode, String pTransformation, Key pKey) throws Exception {
        Cipher cipher = Cipher.getInstance(pTransformation);
        cipher.init(pOpMode, pKey);
        return cipher;
    }

    public static Cipher getCipher(int pOpMode, Key pKey) throws CryptException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
            cipher.init(pOpMode, pKey, new IvParameterSpec(pKey.getEncoded()));
            return cipher;
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }
}

