/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CubicSampler {
    private static final int GAUSSIAN_SAMPLE_RADIUS = 2;
    private static final int GAUSSIAN_SAMPLE_BREADTH = 6;
    private static final double[] GAUSSIAN_SAMPLE_KERNEL = new double[]{0.0, 1.0, 4.0, 6.0, 4.0, 1.0, 0.0};

    private CubicSampler() {
    }

    public static Vec3 gaussianSampleVec3(Vec3 p_130039_, Vec3Fetcher p_130040_) {
        int i = Mth.floor(p_130039_.x());
        int j = Mth.floor(p_130039_.y());
        int k = Mth.floor(p_130039_.z());
        double d0 = p_130039_.x() - (double)i;
        double d1 = p_130039_.y() - (double)j;
        double d2 = p_130039_.z() - (double)k;
        double d3 = 0.0;
        Vec3 vec3 = Vec3.ZERO;
        int l = 0;
        while (l < 6) {
            double d4 = Mth.lerp(d0, GAUSSIAN_SAMPLE_KERNEL[l + 1], GAUSSIAN_SAMPLE_KERNEL[l]);
            int i1 = i - 2 + l;
            int j1 = 0;
            while (j1 < 6) {
                double d5 = Mth.lerp(d1, GAUSSIAN_SAMPLE_KERNEL[j1 + 1], GAUSSIAN_SAMPLE_KERNEL[j1]);
                int k1 = j - 2 + j1;
                int l1 = 0;
                while (l1 < 6) {
                    double d6 = Mth.lerp(d2, GAUSSIAN_SAMPLE_KERNEL[l1 + 1], GAUSSIAN_SAMPLE_KERNEL[l1]);
                    int i2 = k - 2 + l1;
                    double d7 = d4 * d5 * d6;
                    d3 += d7;
                    vec3 = vec3.add(p_130040_.fetch(i1, k1, i2).scale(d7));
                    ++l1;
                }
                ++j1;
            }
            ++l;
        }
        return vec3.scale(1.0 / d3);
    }

    @FunctionalInterface
    public static interface Vec3Fetcher {
        public Vec3 fetch(int var1, int var2, int var3);
    }
}

