/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C>
extends ToFloatFunction<C> {
    @VisibleForDebug
    public String parityString();

    public float min();

    public float max();

    public CubicSpline<C> mapAll(CoordinateVisitor<C> var1);

    public static <C> Codec<CubicSpline<C>> codec(Codec<ToFloatFunction<C>> p_184263_) {
        record Point<C>(float location, CubicSpline<C> value, float derivative) {
        }
        MutableObject mutableobject = new MutableObject();
        Codec codec = RecordCodecBuilder.create(p_184270_ -> p_184270_.group((App)Codec.FLOAT.fieldOf("location").forGetter(Point::location), (App)ExtraCodecs.lazyInitializedCodec(() -> ((MutableObject)mutableobject).getValue()).fieldOf("value").forGetter(Point::value), (App)Codec.FLOAT.fieldOf("derivative").forGetter(Point::derivative)).apply((Applicative)p_184270_, (p_184242_, p_184243_, p_184244_) -> new Point(p_184242_.floatValue(), p_184243_, p_184244_.floatValue())));
        Codec codec1 = RecordCodecBuilder.create(p_184267_ -> p_184267_.group((App)p_184263_.fieldOf("coordinate").forGetter(Multipoint::coordinate), (App)ExtraCodecs.nonEmptyList(codec.listOf()).fieldOf("points").forGetter(p_184272_ -> IntStream.range(0, p_184272_.locations.length).mapToObj(p_184249_ -> new Point(p_184272_.locations()[p_184249_], p_184272_.values().get(p_184249_), p_184272_.derivatives()[p_184249_])).toList())).apply((Applicative)p_184267_, (p_184258_, p_184259_) -> {
            float[] afloat = new float[p_184259_.size()];
            ImmutableList.Builder builder = ImmutableList.builder();
            float[] afloat1 = new float[p_184259_.size()];
            int i = 0;
            while (i < p_184259_.size()) {
                Point point = (Point)p_184259_.get(i);
                afloat[i] = point.location();
                builder.add(point.value());
                afloat1[i] = point.derivative();
                ++i;
            }
            return new Multipoint(p_184258_, afloat, builder.build(), afloat1);
        }));
        mutableobject.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)codec1).xmap(p_184261_ -> (CubicSpline)p_184261_.map(Constant::new, p_184246_ -> p_184246_), p_184251_ -> {
            Either either;
            if (p_184251_ instanceof Constant) {
                Constant constant = (Constant)p_184251_;
                either = Either.left((Object)Float.valueOf(constant.value()));
            } else {
                either = Either.right((Object)p_184251_);
            }
            return either;
        }));
        return (Codec)mutableobject.getValue();
    }

    public static <C> CubicSpline<C> constant(float p_184240_) {
        return new Constant(p_184240_);
    }

    public static <C> Builder<C> builder(ToFloatFunction<C> p_184253_) {
        return new Builder<C>(p_184253_);
    }

    public static <C> Builder<C> builder(ToFloatFunction<C> p_184255_, ToFloatFunction<Float> p_184256_) {
        return new Builder<C>(p_184255_, p_184256_);
    }

    public static final class Builder<C> {
        private final ToFloatFunction<C> coordinate;
        private final ToFloatFunction<Float> valueTransformer;
        private final FloatList locations = new FloatArrayList();
        private final List<CubicSpline<C>> values = Lists.newArrayList();
        private final FloatList derivatives = new FloatArrayList();

        protected Builder(ToFloatFunction<C> p_184293_) {
            this(p_184293_, p_184307_ -> p_184307_.floatValue());
        }

        protected Builder(ToFloatFunction<C> p_184295_, ToFloatFunction<Float> p_184296_) {
            this.coordinate = p_184295_;
            this.valueTransformer = p_184296_;
        }

        public Builder<C> addPoint(float p_184299_, float p_184300_, float p_184301_) {
            return this.addPoint(p_184299_, new Constant(this.valueTransformer.apply(Float.valueOf(p_184300_))), p_184301_);
        }

        public Builder<C> addPoint(float p_184303_, CubicSpline<C> p_184304_, float p_184305_) {
            if (!this.locations.isEmpty() && p_184303_ <= this.locations.getFloat(this.locations.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.locations.add(p_184303_);
            this.values.add(p_184304_);
            this.derivatives.add(p_184305_);
            return this;
        }

        public CubicSpline<C> build() {
            if (this.locations.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return new Multipoint<C>(this.coordinate, this.locations.toFloatArray(), ImmutableList.copyOf(this.values), this.derivatives.toFloatArray());
        }
    }

    @VisibleForDebug
    public record Constant<C>(float value) implements CubicSpline<C>
    {
        @Override
        public float apply(C p_184313_) {
            return this.value;
        }

        @Override
        public String parityString() {
            return String.format("k=%.3f", Float.valueOf(this.value));
        }

        @Override
        public float min() {
            return this.value;
        }

        @Override
        public float max() {
            return this.value;
        }

        @Override
        public CubicSpline<C> mapAll(CoordinateVisitor<C> p_211581_) {
            return this;
        }
    }

    public static interface CoordinateVisitor<C> {
        public ToFloatFunction<C> visit(ToFloatFunction<C> var1);
    }

    @VisibleForDebug
    public record Multipoint<C>(ToFloatFunction<C> coordinate, float[] locations, List<CubicSpline<C>> values, float[] derivatives) implements CubicSpline<C>
    {
        public Multipoint {
            if (locations.length != values.size() || locations.length != derivatives.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + locations.length + " " + values.size() + " " + derivatives.length);
            }
        }

        @Override
        public float apply(C p_184340_) {
            float f = this.coordinate.apply(p_184340_);
            int i = Mth.binarySearch(0, this.locations.length, p_184333_ -> f < this.locations[p_184333_]) - 1;
            int j = this.locations.length - 1;
            if (i < 0) {
                return this.values.get(0).apply(p_184340_) + this.derivatives[0] * (f - this.locations[0]);
            }
            if (i == j) {
                return this.values.get(j).apply(p_184340_) + this.derivatives[j] * (f - this.locations[j]);
            }
            float f1 = this.locations[i];
            float f2 = this.locations[i + 1];
            float f3 = (f - f1) / (f2 - f1);
            ToFloatFunction tofloatfunction = this.values.get(i);
            ToFloatFunction tofloatfunction1 = this.values.get(i + 1);
            float f4 = this.derivatives[i];
            float f5 = this.derivatives[i + 1];
            float f6 = tofloatfunction.apply(p_184340_);
            float f7 = tofloatfunction1.apply(p_184340_);
            float f8 = f4 * (f2 - f1) - (f7 - f6);
            float f9 = -f5 * (f2 - f1) + (f7 - f6);
            return Mth.lerp(f3, f6, f7) + f3 * (1.0f - f3) * Mth.lerp(f3, f8, f9);
        }

        @Override
        @VisibleForTesting
        public String parityString() {
            return "Spline{coordinate=" + this.coordinate + ", locations=" + this.a(this.locations) + ", derivatives=" + this.a(this.derivatives) + ", values=" + this.values.stream().map(CubicSpline::parityString).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String a(float[] p_184335_) {
            return "[" + IntStream.range(0, p_184335_.length).mapToDouble(p_184338_ -> p_184335_[p_184338_]).mapToObj(p_184330_ -> String.format(Locale.ROOT, "%.3f", p_184330_)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public float min() {
            return (float)this.values().stream().mapToDouble(CubicSpline::min).min().orElseThrow();
        }

        @Override
        public float max() {
            return (float)this.values().stream().mapToDouble(CubicSpline::max).max().orElseThrow();
        }

        @Override
        public CubicSpline<C> mapAll(CoordinateVisitor<C> p_211585_) {
            return new Multipoint<C>(p_211585_.visit(this.coordinate), this.locations, this.values().stream().map(p_211588_ -> p_211588_.mapAll(p_211585_)).toList(), this.derivatives);
        }
    }
}

