/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class DebugBuffer<T> {
    private final AtomicReferenceArray<T> data;
    private final AtomicInteger index;

    public DebugBuffer(int p_144623_) {
        this.data = new AtomicReferenceArray(p_144623_);
        this.index = new AtomicInteger(0);
    }

    public void push(T p_144626_) {
        int k;
        int j;
        int i = this.data.length();
        while (!this.index.compareAndSet(j = this.index.get(), k = (j + 1) % i)) {
        }
        this.data.set(k, p_144626_);
    }

    public List<T> dump() {
        int i = this.index.get();
        ImmutableList.Builder builder = ImmutableList.builder();
        int j = 0;
        while (j < this.data.length()) {
            int k = Math.floorMod(i - j, this.data.length());
            T t = this.data.get(k);
            if (t != null) {
                builder.add(t);
            }
            ++j;
        }
        return builder.build();
    }
}

