/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import org.apache.commons.lang3.mutable.MutableObject;

public class ExtraCodecs {
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, p_184429_ -> "Value must be non-negative: " + p_184429_);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, p_184375_ -> "Value must be positive: " + p_184375_);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, p_184373_ -> "Value must be positive: " + p_184373_);

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> pFirst, Codec<S> pSecond) {
        return new XorCodec<F, S>(pFirst, pSecond);
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> p_184362_, String p_184363_, String p_184364_, BiFunction<P, P, DataResult<I>> p_184365_, Function<I, P> p_184366_, Function<I, P> p_184367_) {
        Codec codec = Codec.list(p_184362_).comapFlatMap(p_184398_ -> Util.fixedSize(p_184398_, 2).flatMap(p_184445_ -> {
            Object p = p_184445_.get(0);
            Object p1 = p_184445_.get(1);
            return (DataResult)p_184365_.apply(p, p1);
        }), p_184459_ -> ImmutableList.of(p_184366_.apply(p_184459_), p_184367_.apply(p_184459_)));
        Codec codec1 = RecordCodecBuilder.create(p_184360_ -> p_184360_.group((App)p_184362_.fieldOf(p_184363_).forGetter(Pair::getFirst), (App)p_184362_.fieldOf(p_184364_).forGetter(Pair::getSecond)).apply((Applicative)p_184360_, Pair::of)).comapFlatMap(p_184392_ -> (DataResult)p_184365_.apply(p_184392_.getFirst(), p_184392_.getSecond()), p_184449_ -> Pair.of(p_184366_.apply(p_184449_), p_184367_.apply(p_184449_)));
        Codec codec2 = new EitherCodec(codec, codec1).xmap(p_184355_ -> p_184355_.map(p_184461_ -> p_184461_, p_184455_ -> p_184455_), Either::left);
        return Codec.either(p_184362_, (Codec)codec2).comapFlatMap(p_184389_ -> (DataResult)p_184389_.map(p_184395_ -> (DataResult)p_184365_.apply(p_184395_, p_184395_), DataResult::success), p_184411_ -> {
            Object p1;
            Object p = p_184366_.apply(p_184411_);
            return Objects.equals(p, p1 = p_184367_.apply(p_184411_)) ? Either.left(p) : Either.right((Object)p_184411_);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(A p_184382_) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> p_184466_, T p_184467_, DataResult<Pair<A, T>> p_184468_) {
                MutableObject mutableobject = new MutableObject();
                Optional optional = p_184468_.resultOrPartial(arg_0 -> ((MutableObject)mutableobject).setValue(arg_0));
                return optional.isPresent() ? p_184468_ : DataResult.error((String)("(" + (String)mutableobject.getValue() + " -> using default)"), (Object)Pair.of((Object)p_184382_, p_184467_));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184470_, A p_184471_, DataResult<T> p_184472_) {
                return p_184472_;
            }

            public String toString() {
                return "OrElsePartial[" + p_184382_ + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> p_184422_, IntFunction<E> p_184423_, int p_184424_) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(p_184423_.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element id: " + p_184414_))), p_184420_ -> {
            int i = p_184422_.applyAsInt(p_184420_);
            return i == p_184424_ ? DataResult.error((String)("Element with unknown id: " + p_184420_)) : DataResult.success((Object)i);
        });
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> p_184406_, Function<String, E> p_184407_) {
        return Codec.STRING.flatXmap(p_184404_ -> Optional.ofNullable(p_184407_.apply((String)p_184404_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element name:" + p_184404_))), p_184401_ -> Optional.ofNullable((String)p_184406_.apply(p_184401_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Element with unknown name: " + p_184401_))));
    }

    public static <E> Codec<E> orCompressed(Codec<E> p_184426_, Codec<E> p_184427_) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                return p_184484_.compressMaps() ? p_184427_.encode(p_184483_, p_184484_, p_184485_) : p_184426_.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                return p_184480_.compressMaps() ? p_184427_.decode(p_184480_, p_184481_) : p_184426_.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return p_184426_ + " orCompressed " + p_184427_;
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> p_184369_, Function<E, Lifecycle> p_184370_, Function<E, Lifecycle> p_184371_) {
        return p_184369_.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> p_184497_, T p_184498_, DataResult<Pair<E, T>> p_184499_) {
                return p_184499_.result().map(p_184495_ -> p_184499_.setLifecycle((Lifecycle)p_184370_.apply(p_184495_.getFirst()))).orElse(p_184499_);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184501_, E p_184502_, DataResult<T> p_184503_) {
                return p_184503_.setLifecycle((Lifecycle)p_184371_.apply(p_184502_));
            }

            public String toString() {
                return "WithLifecycle[" + p_184370_ + " " + p_184371_ + "]";
            }
        });
    }

    private static <N extends Number> Function<N, DataResult<N>> checkRangeWithMessage(N pMin, N pMax, Function<N, String> pErrorMessage) {
        return p_184438_ -> ((Comparable)((Object)p_184438_)).compareTo(pMin) >= 0 && ((Comparable)((Object)p_184438_)).compareTo(pMax) <= 0 ? DataResult.success((Object)p_184438_) : DataResult.error((String)((String)pErrorMessage.apply(p_184438_)));
    }

    private static Codec<Integer> intRangeWithMessage(int pMin, int pMax, Function<Integer, String> pErrorMessage) {
        Function<Integer, DataResult<Integer>> function = ExtraCodecs.checkRangeWithMessage(pMin, pMax, pErrorMessage);
        return Codec.INT.flatXmap(function, function);
    }

    private static <N extends Number> Function<N, DataResult<N>> checkRangeMinExclusiveWithMessage(N p_184431_, N p_184432_, Function<N, String> p_184433_) {
        return p_184380_ -> ((Comparable)((Object)p_184380_)).compareTo(p_184431_) > 0 && ((Comparable)((Object)p_184380_)).compareTo(p_184432_) <= 0 ? DataResult.success((Object)p_184380_) : DataResult.error((String)((String)p_184433_.apply(p_184380_)));
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float p_184351_, float p_184352_, Function<Float, String> p_184353_) {
        Function<Float, DataResult<Float>> function = ExtraCodecs.checkRangeMinExclusiveWithMessage(Float.valueOf(p_184351_), Float.valueOf(p_184352_), p_184353_);
        return Codec.FLOAT.flatXmap(function, function);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> nonEmptyListCheck() {
        return p_184442_ -> p_184442_.isEmpty() ? DataResult.error((String)"List must have contents") : DataResult.success((Object)p_184442_);
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> pCodec) {
        return pCodec.flatXmap(ExtraCodecs.nonEmptyListCheck(), ExtraCodecs.nonEmptyListCheck());
    }

    public static <T> Function<HolderSet<T>, DataResult<HolderSet<T>>> nonEmptyHolderSetCheck() {
        return p_203975_ -> p_203975_.unwrap().right().filter(List::isEmpty).isPresent() ? DataResult.error((String)"List must have contents") : DataResult.success((Object)p_203975_);
    }

    public static <T> Codec<HolderSet<T>> nonEmptyHolderSet(Codec<HolderSet<T>> p_203983_) {
        return p_203983_.flatXmap(ExtraCodecs.nonEmptyHolderSetCheck(), ExtraCodecs.nonEmptyHolderSetCheck());
    }

    public static <A> Codec<A> lazyInitializedCodec(Supplier<Codec<A>> p_184416_) {
        return new LazyInitializedCodec<A>(p_184416_);
    }

    public static <E> MapCodec<E> retrieveContext(Function<DynamicOps<?>, DataResult<E>> p_203977_) {
        class ContextRetrievalCodec
        extends MapCodec<E> {
            private final /* synthetic */ Function val$p_203977_;

            ContextRetrievalCodec(Function function) {
                this.val$p_203977_ = function;
            }

            public <T> RecordBuilder<T> encode(E p_203993_, DynamicOps<T> p_203994_, RecordBuilder<T> p_203995_) {
                return p_203995_;
            }

            public <T> DataResult<E> decode(DynamicOps<T> p_203990_, MapLike<T> p_203991_) {
                return (DataResult)this.val$p_203977_.apply(p_203990_);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + this.val$p_203977_ + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> p_203997_) {
                return Stream.empty();
            }
        }
        return new ContextRetrievalCodec(p_203977_);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> ensureHomogenous(Function<E, T> p_203985_) {
        return p_203980_ -> {
            Iterator iterator = p_203980_.iterator();
            if (iterator.hasNext()) {
                Object t = p_203985_.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object t1 = p_203985_.apply(e);
                    if (t1 == t) continue;
                    return DataResult.error((String)("Mixed type list: element " + e + " had type " + t1 + ", but list is of type " + t));
                }
            }
            return DataResult.success((Object)p_203980_, (Lifecycle)Lifecycle.stable());
        };
    }

    static final class EitherCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public EitherCodec(Codec<F> p_184508_, Codec<S> p_184509_) {
            this.first = p_184508_;
            this.second = p_184509_;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> p_184530_, T p_184531_) {
            DataResult dataresult = this.first.decode(p_184530_, p_184531_).map(p_184524_ -> p_184524_.mapFirst(Either::left));
            if (!dataresult.error().isPresent()) {
                return dataresult;
            }
            DataResult dataresult1 = this.second.decode(p_184530_, p_184531_).map(p_184515_ -> p_184515_.mapFirst(Either::right));
            return !dataresult1.error().isPresent() ? dataresult1 : dataresult.apply2((p_184517_, p_184518_) -> p_184518_, dataresult1);
        }

        public <T> DataResult<T> encode(Either<F, S> p_184511_, DynamicOps<T> p_184512_, T p_184513_) {
            return (DataResult)p_184511_.map(p_184528_ -> this.first.encode(p_184528_, p_184512_, p_184513_), p_184522_ -> this.second.encode(p_184522_, p_184512_, p_184513_));
        }

        public boolean equals(Object p_184537_) {
            if (this == p_184537_) {
                return true;
            }
            if (p_184537_ != null && this.getClass() == p_184537_.getClass()) {
                EitherCodec eithercodec = (EitherCodec)p_184537_;
                return Objects.equals(this.first, eithercodec.first) && Objects.equals(this.second, eithercodec.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "EitherCodec[" + this.first + ", " + this.second + "]";
        }
    }

    record LazyInitializedCodec<A>(Supplier<Codec<A>> delegate) implements Codec<A>
    {
        LazyInitializedCodec(Supplier<Codec<A>> delegate) {
            this.delegate = delegate = Suppliers.memoize(() -> delegate.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> p_184545_, T p_184546_) {
            return this.delegate.get().decode(p_184545_, p_184546_);
        }

        public <T> DataResult<T> encode(A p_184548_, DynamicOps<T> p_184549_, T p_184550_) {
            return this.delegate.get().encode(p_184548_, p_184549_, p_184550_);
        }
    }

    static final class XorCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public XorCodec(Codec<F> pFirst, Codec<S> pSecond) {
            this.first = pFirst;
            this.second = pSecond;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> pOps, T pInput) {
            DataResult dataresult = this.first.decode(pOps, pInput).map(p_144673_ -> p_144673_.mapFirst(Either::left));
            DataResult dataresult1 = this.second.decode(pOps, pInput).map(p_144667_ -> p_144667_.mapFirst(Either::right));
            Optional optional = dataresult.result();
            Optional optional1 = dataresult1.result();
            if (optional.isPresent() && optional1.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional1.get()), (Object)((Pair)optional.get()));
            }
            return optional.isPresent() ? dataresult : dataresult1;
        }

        public <T> DataResult<T> encode(Either<F, S> pInput, DynamicOps<T> pOps, T pPrefix) {
            return (DataResult)pInput.map(p_144677_ -> this.first.encode(p_144677_, pOps, pPrefix), p_144671_ -> this.second.encode(p_144671_, pOps, pPrefix));
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther != null && this.getClass() == pOther.getClass()) {
                XorCodec xorcodec = (XorCodec)pOther;
                return Objects.equals(this.first, xorcodec.first) && Objects.equals(this.second, xorcodec.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + this.first + ", " + this.second + "]";
        }
    }
}

