/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;

public class LowerCaseEnumTypeAdapterFactory
implements TypeAdapterFactory {
    @Nullable
    public <T> TypeAdapter<T> create(Gson p_13982_, TypeToken<T> p_13983_) {
        Class oclass = p_13983_.getRawType();
        if (!oclass.isEnum()) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        T[] TArray = oclass.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object t = TArray[n2];
            map.put(this.toLowercase(t), t);
            ++n2;
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter p_13992_, T p_13993_) throws IOException {
                if (p_13993_ == null) {
                    p_13992_.nullValue();
                } else {
                    p_13992_.value(LowerCaseEnumTypeAdapterFactory.this.toLowercase(p_13993_));
                }
            }

            @Nullable
            public T read(JsonReader p_13990_) throws IOException {
                if (p_13990_.peek() == JsonToken.NULL) {
                    p_13990_.nextNull();
                    return null;
                }
                return map.get(p_13990_.nextString());
            }
        };
    }

    String toLowercase(Object pObject) {
        return pObject instanceof Enum ? ((Enum)pObject).name().toLowerCase(Locale.ROOT) : pObject.toString().toLowerCase(Locale.ROOT);
    }
}

