/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Random;
import java.util.UUID;
import java.util.function.IntPredicate;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.optifine.util.MathUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Mth {
    private static final int BIG_ENOUGH_INT = 1024;
    private static final float BIG_ENOUGH_FLOAT = 1024.0f;
    private static final long UUID_VERSION = 61440L;
    private static final long UUID_VERSION_TYPE_4 = 16384L;
    private static final long UUID_VARIANT = -4611686018427387904L;
    private static final long UUID_VARIANT_2 = Long.MIN_VALUE;
    public static final float PI = (float)Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;
    public static final float EPSILON = 1.0E-5f;
    public static final float SQRT_OF_TWO = Mth.sqrt(2.0f);
    private static final float SIN_SCALE = 10430.378f;
    private static final float[] SIN = Util.make(new float[65536], p_14076_0_ -> {
        int i = 0;
        while (i < ((float[])p_14076_0_).length) {
            p_14076_0_[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
            ++i;
        }
    });
    private static final Random RANDOM = new Random();
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION;
    private static final double ONE_SIXTH = 0.16666666666666666;
    private static final int FRAC_EXP = 8;
    private static final int LUT_SIZE = 257;
    private static final double FRAC_BIAS;
    private static final double[] ASIN_TAB;
    private static final double[] COS_TAB;
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = 4095;
    private static final int SIN_COUNT = 4096;
    private static final int SIN_COUNT_D4 = 1024;
    public static final float PI2;
    public static final float PId2;
    private static final float radToIndex;
    public static final float deg2Rad;
    private static final float[] SIN_TABLE_FAST;
    public static boolean fastMath;

    static {
        int[] nArray = new int[32];
        nArray[1] = 1;
        nArray[2] = 28;
        nArray[3] = 2;
        nArray[4] = 29;
        nArray[5] = 14;
        nArray[6] = 24;
        nArray[7] = 3;
        nArray[8] = 30;
        nArray[9] = 22;
        nArray[10] = 20;
        nArray[11] = 15;
        nArray[12] = 25;
        nArray[13] = 17;
        nArray[14] = 4;
        nArray[15] = 8;
        nArray[16] = 31;
        nArray[17] = 27;
        nArray[18] = 13;
        nArray[19] = 23;
        nArray[20] = 21;
        nArray[21] = 19;
        nArray[22] = 16;
        nArray[23] = 7;
        nArray[24] = 26;
        nArray[25] = 12;
        nArray[26] = 18;
        nArray[27] = 6;
        nArray[28] = 11;
        nArray[29] = 5;
        nArray[30] = 10;
        nArray[31] = 9;
        MULTIPLY_DE_BRUIJN_BIT_POSITION = nArray;
        FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
        ASIN_TAB = new double[257];
        COS_TAB = new double[257];
        PI2 = MathUtils.roundToFloat(Math.PI * 2);
        PId2 = MathUtils.roundToFloat(1.5707963267948966);
        radToIndex = MathUtils.roundToFloat(651.8986469044033);
        deg2Rad = MathUtils.roundToFloat(Math.PI / 180);
        SIN_TABLE_FAST = new float[4096];
        fastMath = false;
        int i = 0;
        while (i < 257) {
            double d0 = (double)i / 256.0;
            double d1 = Math.asin(d0);
            Mth.COS_TAB[i] = Math.cos(d1);
            Mth.ASIN_TAB[i] = d1;
            ++i;
        }
        int j = 0;
        while (j < SIN_TABLE_FAST.length) {
            Mth.SIN_TABLE_FAST[j] = MathUtils.roundToFloat(Math.sin((double)j * Math.PI * 2.0 / 4096.0));
            ++j;
        }
    }

    public static float sin(float pValue) {
        return fastMath ? SIN_TABLE_FAST[(int)(pValue * radToIndex) & 0xFFF] : SIN[(int)(pValue * 10430.378f) & 0xFFFF];
    }

    public static float cos(float pValue) {
        return fastMath ? SIN_TABLE_FAST[(int)(pValue * radToIndex + 1024.0f) & 0xFFF] : SIN[(int)(pValue * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float sqrt(float pValue) {
        return (float)Math.sqrt(pValue);
    }

    public static int floor(float pValue) {
        int i = (int)pValue;
        return pValue < (float)i ? i - 1 : i;
    }

    public static int fastFloor(double pValue) {
        return (int)(pValue + 1024.0) - 1024;
    }

    public static int floor(double pValue) {
        int i = (int)pValue;
        return pValue < (double)i ? i - 1 : i;
    }

    public static long lfloor(double pValue) {
        long i = (long)pValue;
        return pValue < (double)i ? i - 1L : i;
    }

    public static int absFloor(double p_144940_) {
        return (int)(p_144940_ >= 0.0 ? p_144940_ : -p_144940_ + 1.0);
    }

    public static float abs(float pValue) {
        return Math.abs(pValue);
    }

    public static int abs(int pValue) {
        return Math.abs(pValue);
    }

    public static int ceil(float pValue) {
        int i = (int)pValue;
        return pValue > (float)i ? i + 1 : i;
    }

    public static int ceil(double pValue) {
        int i = (int)pValue;
        return pValue > (double)i ? i + 1 : i;
    }

    public static byte clamp(byte pValue, byte pMin, byte pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static int clamp(int pValue, int pMin, int pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static long clamp(long pValue, long pMin, long pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static float clamp(float pValue, float pMin, float pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static double clamp(double pValue, double pMin, double pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static double clampedLerp(double pStart, double p_14087_, double pEnd) {
        if (pEnd < 0.0) {
            return pStart;
        }
        return pEnd > 1.0 ? p_14087_ : Mth.lerp(pEnd, pStart, p_14087_);
    }

    public static float clampedLerp(float pStart, float p_144922_, float pEnd) {
        if (pEnd < 0.0f) {
            return pStart;
        }
        return pEnd > 1.0f ? p_144922_ : Mth.lerp(pEnd, pStart, p_144922_);
    }

    public static double absMax(double pX, double p_14007_) {
        if (pX < 0.0) {
            pX = -pX;
        }
        if (p_14007_ < 0.0) {
            p_14007_ = -p_14007_;
        }
        return pX > p_14007_ ? pX : p_14007_;
    }

    public static int intFloorDiv(int pX, int pY) {
        return Math.floorDiv(pX, pY);
    }

    public static int nextInt(Random pRandom, int pMinimum, int pMaximum) {
        return pMinimum >= pMaximum ? pMinimum : pRandom.nextInt(pMaximum - pMinimum + 1) + pMinimum;
    }

    public static float nextFloat(Random pRandom, float pMinimum, float pMaximum) {
        return pMinimum >= pMaximum ? pMinimum : pRandom.nextFloat() * (pMaximum - pMinimum) + pMinimum;
    }

    public static double nextDouble(Random pRandom, double pMinimum, double p_14067_) {
        return pMinimum >= p_14067_ ? pMinimum : pRandom.nextDouble() * (p_14067_ - pMinimum) + pMinimum;
    }

    public static double a(long[] p_14079_) {
        long i = 0L;
        long[] lArray = p_14079_;
        int n = p_14079_.length;
        int n2 = 0;
        while (n2 < n) {
            long j = lArray[n2];
            i += j;
            ++n2;
        }
        return (double)i / (double)p_14079_.length;
    }

    public static boolean equal(float pX, float p_14035_) {
        return Math.abs(p_14035_ - pX) < 1.0E-5f;
    }

    public static boolean equal(double pX, double p_14084_) {
        return Math.abs(p_14084_ - pX) < (double)1.0E-5f;
    }

    public static int positiveModulo(int pNumerator, int p_14102_) {
        return Math.floorMod(pNumerator, p_14102_);
    }

    public static float positiveModulo(float pNumerator, float p_14093_) {
        return (pNumerator % p_14093_ + p_14093_) % p_14093_;
    }

    public static double positiveModulo(double pNumerator, double p_14111_) {
        return (pNumerator % p_14111_ + p_14111_) % p_14111_;
    }

    public static int wrapDegrees(int pValue) {
        int i = pValue % 360;
        if (i >= 180) {
            i -= 360;
        }
        if (i < -180) {
            i += 360;
        }
        return i;
    }

    public static float wrapDegrees(float pValue) {
        float f = pValue % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static double wrapDegrees(double pValue) {
        double d0 = pValue % 360.0;
        if (d0 >= 180.0) {
            d0 -= 360.0;
        }
        if (d0 < -180.0) {
            d0 += 360.0;
        }
        return d0;
    }

    public static float degreesDifference(float p_14119_, float p_14120_) {
        return Mth.wrapDegrees(p_14120_ - p_14119_);
    }

    public static float degreesDifferenceAbs(float p_14146_, float p_14147_) {
        return Mth.abs(Mth.degreesDifference(p_14146_, p_14147_));
    }

    public static float rotateIfNecessary(float p_14095_, float p_14096_, float p_14097_) {
        float f = Mth.degreesDifference(p_14095_, p_14096_);
        float f1 = Mth.clamp(f, -p_14097_, p_14097_);
        return p_14096_ - f1;
    }

    public static float approach(float p_14122_, float p_14123_, float p_14124_) {
        p_14124_ = Mth.abs(p_14124_);
        return p_14122_ < p_14123_ ? Mth.clamp(p_14122_ + p_14124_, p_14122_, p_14123_) : Mth.clamp(p_14122_ - p_14124_, p_14123_, p_14122_);
    }

    public static float approachDegrees(float p_14149_, float p_14150_, float p_14151_) {
        float f = Mth.degreesDifference(p_14149_, p_14150_);
        return Mth.approach(p_14149_, p_14149_ + f, p_14151_);
    }

    public static int getInt(String pValue, int pDefaultValue) {
        return NumberUtils.toInt((String)pValue, (int)pDefaultValue);
    }

    public static int getInt(String pValue, int pDefaultValue, int pMax) {
        return Math.max(pMax, Mth.getInt(pValue, pDefaultValue));
    }

    public static double getDouble(String pValue, double pDefaultValue) {
        try {
            return Double.parseDouble(pValue);
        }
        catch (Throwable throwable) {
            return pDefaultValue;
        }
    }

    public static double getDouble(String pValue, double pDefaultValue, double p_144904_) {
        return Math.max(p_144904_, Mth.getDouble(pValue, pDefaultValue));
    }

    public static int smallestEncompassingPowerOfTwo(int pValue) {
        int i = pValue - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public static boolean isPowerOfTwo(int pValue) {
        return pValue != 0 && (pValue & pValue - 1) == 0;
    }

    public static int ceillog2(int pValue) {
        pValue = Mth.isPowerOfTwo(pValue) ? pValue : Mth.smallestEncompassingPowerOfTwo(pValue);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)pValue * 125613361L >> 27) & 0x1F];
    }

    public static int log2(int pValue) {
        return Mth.ceillog2(pValue) - (Mth.isPowerOfTwo(pValue) ? 0 : 1);
    }

    public static int color(float pR, float pG, float pB) {
        return Mth.color(Mth.floor(pR * 255.0f), Mth.floor(pG * 255.0f), Mth.floor(pB * 255.0f));
    }

    public static int color(int pR, int pG, int pB) {
        int i = (pR << 8) + pG;
        return (i << 8) + pB;
    }

    public static int colorMultiply(int p_144933_, int p_144934_) {
        int i = (p_144933_ & 0xFF0000) >> 16;
        int j = (p_144934_ & 0xFF0000) >> 16;
        int k = (p_144933_ & 0xFF00) >> 8;
        int l = (p_144934_ & 0xFF00) >> 8;
        int i1 = (p_144933_ & 0xFF) >> 0;
        int j1 = (p_144934_ & 0xFF) >> 0;
        int k1 = (int)((float)i * (float)j / 255.0f);
        int l1 = (int)((float)k * (float)l / 255.0f);
        int i2 = (int)((float)i1 * (float)j1 / 255.0f);
        return p_144933_ & 0xFF000000 | k1 << 16 | l1 << 8 | i2;
    }

    public static int colorMultiply(int p_144882_, float p_144883_, float p_144884_, float p_144885_) {
        int i = (p_144882_ & 0xFF0000) >> 16;
        int j = (p_144882_ & 0xFF00) >> 8;
        int k = (p_144882_ & 0xFF) >> 0;
        int l = (int)((float)i * p_144883_);
        int i1 = (int)((float)j * p_144884_);
        int j1 = (int)((float)k * p_144885_);
        return p_144882_ & 0xFF000000 | l << 16 | i1 << 8 | j1;
    }

    public static float frac(float pNumber) {
        return pNumber - (float)Mth.floor(pNumber);
    }

    public static double frac(double pNumber) {
        return pNumber - (double)Mth.lfloor(pNumber);
    }

    public static Vec3 catmullRomSplinePos(Vec3 p_144893_, Vec3 p_144894_, Vec3 p_144895_, Vec3 p_144896_, double p_144897_) {
        double d0 = ((-p_144897_ + 2.0) * p_144897_ - 1.0) * p_144897_ * 0.5;
        double d1 = ((3.0 * p_144897_ - 5.0) * p_144897_ * p_144897_ + 2.0) * 0.5;
        double d2 = ((-3.0 * p_144897_ + 4.0) * p_144897_ + 1.0) * p_144897_ * 0.5;
        double d3 = (p_144897_ - 1.0) * p_144897_ * p_144897_ * 0.5;
        return new Vec3(p_144893_.x * d0 + p_144894_.x * d1 + p_144895_.x * d2 + p_144896_.x * d3, p_144893_.y * d0 + p_144894_.y * d1 + p_144895_.y * d2 + p_144896_.y * d3, p_144893_.z * d0 + p_144894_.z * d1 + p_144895_.z * d2 + p_144896_.z * d3);
    }

    public static long getSeed(Vec3i pPos) {
        return Mth.getSeed(pPos.getX(), pPos.getY(), pPos.getZ());
    }

    public static long getSeed(int pX, int pY, int pZ) {
        long i = (long)(pX * 3129871) ^ (long)pZ * 116129781L ^ (long)pY;
        i = i * i * 42317861L + i * 11L;
        return i >> 16;
    }

    public static UUID createInsecureUUID(Random pRand) {
        long i = pRand.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long j = pRand.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(i, j);
    }

    public static UUID createInsecureUUID() {
        return Mth.createInsecureUUID(RANDOM);
    }

    public static double inverseLerp(double p_14113_, double p_14114_, double p_14115_) {
        return (p_14113_ - p_14114_) / (p_14115_ - p_14114_);
    }

    public static float inverseLerp(float p_184656_, float p_184657_, float p_184658_) {
        return (p_184656_ - p_184657_) / (p_184658_ - p_184657_);
    }

    public static boolean rayIntersectsAABB(Vec3 p_144889_, Vec3 p_144890_, AABB p_144891_) {
        double d0 = (p_144891_.minX + p_144891_.maxX) * 0.5;
        double d1 = (p_144891_.maxX - p_144891_.minX) * 0.5;
        double d2 = p_144889_.x - d0;
        if (Math.abs(d2) > d1 && d2 * p_144890_.x >= 0.0) {
            return false;
        }
        double d3 = (p_144891_.minY + p_144891_.maxY) * 0.5;
        double d4 = (p_144891_.maxY - p_144891_.minY) * 0.5;
        double d5 = p_144889_.y - d3;
        if (Math.abs(d5) > d4 && d5 * p_144890_.y >= 0.0) {
            return false;
        }
        double d6 = (p_144891_.minZ + p_144891_.maxZ) * 0.5;
        double d7 = (p_144891_.maxZ - p_144891_.minZ) * 0.5;
        double d8 = p_144889_.z - d6;
        if (Math.abs(d8) > d7 && d8 * p_144890_.z >= 0.0) {
            return false;
        }
        double d9 = Math.abs(p_144890_.x);
        double d10 = Math.abs(p_144890_.y);
        double d11 = Math.abs(p_144890_.z);
        double d12 = p_144890_.y * d8 - p_144890_.z * d5;
        if (Math.abs(d12) > d4 * d11 + d7 * d10) {
            return false;
        }
        d12 = p_144890_.z * d2 - p_144890_.x * d8;
        if (Math.abs(d12) > d1 * d11 + d7 * d9) {
            return false;
        }
        d12 = p_144890_.x * d5 - p_144890_.y * d2;
        return Math.abs(d12) < d1 * d10 + d4 * d9;
    }

    public static double atan2(double p_14137_, double p_14138_) {
        boolean flag2;
        boolean flag1;
        boolean flag;
        double d0 = p_14138_ * p_14138_ + p_14137_ * p_14137_;
        if (Double.isNaN(d0)) {
            return Double.NaN;
        }
        boolean bl = flag = p_14137_ < 0.0;
        if (flag) {
            p_14137_ = -p_14137_;
        }
        boolean bl2 = flag1 = p_14138_ < 0.0;
        if (flag1) {
            p_14138_ = -p_14138_;
        }
        boolean bl3 = flag2 = p_14137_ > p_14138_;
        if (flag2) {
            double d1 = p_14138_;
            p_14138_ = p_14137_;
            p_14137_ = d1;
        }
        double d9 = Mth.fastInvSqrt(d0);
        p_14138_ *= d9;
        double d2 = FRAC_BIAS + (p_14137_ *= d9);
        int i = (int)Double.doubleToRawLongBits(d2);
        double d3 = ASIN_TAB[i];
        double d4 = COS_TAB[i];
        double d5 = d2 - FRAC_BIAS;
        double d6 = p_14137_ * d4 - p_14138_ * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static float fastInvSqrt(float pNumber) {
        float f = 0.5f * pNumber;
        int i = Float.floatToIntBits(pNumber);
        i = 1597463007 - (i >> 1);
        pNumber = Float.intBitsToFloat(i);
        return pNumber * (1.5f - f * pNumber * pNumber);
    }

    public static double fastInvSqrt(double pNumber) {
        double d0 = 0.5 * pNumber;
        long i = Double.doubleToRawLongBits(pNumber);
        i = 6910469410427058090L - (i >> 1);
        pNumber = Double.longBitsToDouble(i);
        return pNumber * (1.5 - d0 * pNumber * pNumber);
    }

    public static float fastInvCubeRoot(float pNumber) {
        int i = Float.floatToIntBits(pNumber);
        i = 1419967116 - i / 3;
        float f = Float.intBitsToFloat(i);
        f = 0.6666667f * f + 1.0f / (3.0f * f * f * pNumber);
        return 0.6666667f * f + 1.0f / (3.0f * f * f * pNumber);
    }

    public static int hsvToRgb(float pHue, float pSaturation, float pValue) {
        float f5;
        float f4;
        int i = (int)(pHue * 6.0f) % 6;
        float f = pHue * 6.0f - (float)i;
        float f1 = pValue * (1.0f - pSaturation);
        float f2 = pValue * (1.0f - f * pSaturation);
        float f3 = pValue * (1.0f - (1.0f - f) * pSaturation);
        float f6 = switch (i) {
            case 0 -> {
                f4 = pValue;
                f5 = f3;
                yield f1;
            }
            case 1 -> {
                f4 = f2;
                f5 = pValue;
                yield f1;
            }
            case 2 -> {
                f4 = f1;
                f5 = pValue;
                yield f3;
            }
            case 3 -> {
                f4 = f1;
                f5 = f2;
                yield pValue;
            }
            case 4 -> {
                f4 = f3;
                f5 = f1;
                yield pValue;
            }
            case 5 -> {
                f4 = pValue;
                f5 = f1;
                yield f2;
            }
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + pHue + ", " + pSaturation + ", " + pValue);
        };
        int j = Mth.clamp((int)(f4 * 255.0f), 0, 255);
        int k = Mth.clamp((int)(f5 * 255.0f), 0, 255);
        int l = Mth.clamp((int)(f6 * 255.0f), 0, 255);
        return j << 16 | k << 8 | l;
    }

    public static int murmurHash3Mixer(int p_14184_) {
        p_14184_ ^= p_14184_ >>> 16;
        p_14184_ *= -2048144789;
        p_14184_ ^= p_14184_ >>> 13;
        return (p_14184_ *= -1028477387) ^ p_14184_ >>> 16;
    }

    public static long murmurHash3Mixer(long p_144887_) {
        p_144887_ ^= p_144887_ >>> 33;
        p_144887_ *= -49064778989728563L;
        p_144887_ ^= p_144887_ >>> 33;
        return (p_144887_ *= -4265267296055464877L) ^ p_144887_ >>> 33;
    }

    public static double[] a(double ... p_144913_) {
        double d0 = 0.0;
        double[] dArray = p_144913_;
        int n = p_144913_.length;
        int n2 = 0;
        while (n2 < n) {
            double d1 = dArray[n2];
            d0 += d1;
            ++n2;
        }
        int i = 0;
        while (i < p_144913_.length) {
            int n3 = i++;
            p_144913_[n3] = p_144913_[n3] / d0;
        }
        int j = 0;
        while (j < p_144913_.length) {
            int n4 = j;
            p_144913_[n4] = p_144913_[n4] + (j == 0 ? 0.0 : p_144913_[j - 1]);
            ++j;
        }
        return p_144913_;
    }

    public static int a(Random p_144910_, double[] p_144911_) {
        double d0 = p_144910_.nextDouble();
        int i = 0;
        while (i < p_144911_.length) {
            if (d0 < p_144911_[i]) {
                return i;
            }
            ++i;
        }
        return p_144911_.length;
    }

    public static double[] binNormalDistribution(double p_144867_, double p_144868_, double p_144869_, int p_144870_, int p_144871_) {
        double[] adouble = new double[p_144871_ - p_144870_ + 1];
        int i = 0;
        int j = p_144870_;
        while (j <= p_144871_) {
            adouble[i] = Math.max(0.0, p_144867_ * StrictMath.exp(-((double)j - p_144869_) * ((double)j - p_144869_) / (2.0 * p_144868_ * p_144868_)));
            ++i;
            ++j;
        }
        return adouble;
    }

    public static double[] binBiModalNormalDistribution(double p_144858_, double p_144859_, double p_144860_, double p_144861_, double p_144862_, double p_144863_, int p_144864_, int p_144865_) {
        double[] adouble = new double[p_144865_ - p_144864_ + 1];
        int i = 0;
        int j = p_144864_;
        while (j <= p_144865_) {
            adouble[i] = Math.max(0.0, p_144858_ * StrictMath.exp(-((double)j - p_144860_) * ((double)j - p_144860_) / (2.0 * p_144859_ * p_144859_)) + p_144861_ * StrictMath.exp(-((double)j - p_144863_) * ((double)j - p_144863_) / (2.0 * p_144862_ * p_144862_)));
            ++i;
            ++j;
        }
        return adouble;
    }

    public static double[] binLogDistribution(double p_144873_, double p_144874_, int p_144875_, int p_144876_) {
        double[] adouble = new double[p_144876_ - p_144875_ + 1];
        int i = 0;
        int j = p_144875_;
        while (j <= p_144876_) {
            adouble[i] = Math.max(p_144873_ * StrictMath.log(j) + p_144874_, 0.0);
            ++i;
            ++j;
        }
        return adouble;
    }

    public static int binarySearch(int pMin, int pMax, IntPredicate pIsTargetBeforeOrAt) {
        int i = pMax - pMin;
        while (i > 0) {
            int j = i / 2;
            int k = pMin + j;
            if (pIsTargetBeforeOrAt.test(k)) {
                i = j;
                continue;
            }
            pMin = k + 1;
            i -= j + 1;
        }
        return pMin;
    }

    public static float lerp(float pDelta, float p_14181_, float pStart) {
        return p_14181_ + pDelta * (pStart - p_14181_);
    }

    public static double lerp(double pDelta, double p_14141_, double pStart) {
        return p_14141_ + pDelta * (pStart - p_14141_);
    }

    public static double lerp2(double p_14013_, double p_14014_, double p_14015_, double p_14016_, double p_14017_, double p_14018_) {
        return Mth.lerp(p_14014_, Mth.lerp(p_14013_, p_14015_, p_14016_), Mth.lerp(p_14013_, p_14017_, p_14018_));
    }

    public static double lerp3(double p_14020_, double p_14021_, double p_14022_, double p_14023_, double p_14024_, double p_14025_, double p_14026_, double p_14027_, double p_14028_, double p_14029_, double p_14030_) {
        return Mth.lerp(p_14022_, Mth.lerp2(p_14020_, p_14021_, p_14023_, p_14024_, p_14025_, p_14026_), Mth.lerp2(p_14020_, p_14021_, p_14027_, p_14028_, p_14029_, p_14030_));
    }

    public static double smoothstep(double p_14198_) {
        return p_14198_ * p_14198_ * p_14198_ * (p_14198_ * (p_14198_ * 6.0 - 15.0) + 10.0);
    }

    public static double smoothstepDerivative(double p_144947_) {
        return 30.0 * p_144947_ * p_144947_ * (p_144947_ - 1.0) * (p_144947_ - 1.0);
    }

    public static int sign(double pX) {
        if (pX == 0.0) {
            return 0;
        }
        return pX > 0.0 ? 1 : -1;
    }

    public static float rotLerp(float p_14190_, float p_14191_, float p_14192_) {
        return p_14191_ + p_14190_ * Mth.wrapDegrees(p_14192_ - p_14191_);
    }

    public static float diffuseLight(float p_144949_, float p_144950_, float p_144951_) {
        return Math.min(p_144949_ * p_144949_ * 0.6f + p_144950_ * p_144950_ * ((3.0f + p_144950_) / 4.0f) + p_144951_ * p_144951_ * 0.8f, 1.0f);
    }

    @Deprecated
    public static float rotlerp(float p_14202_, float p_14203_, float p_14204_) {
        float f = p_14203_ - p_14202_;
        while (f < -180.0f) {
            f += 360.0f;
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return p_14202_ + p_14204_ * f;
    }

    @Deprecated
    public static float rotWrap(double p_14210_) {
        while (p_14210_ >= 180.0) {
            p_14210_ -= 360.0;
        }
        while (p_14210_ < -180.0) {
            p_14210_ += 360.0;
        }
        return (float)p_14210_;
    }

    public static float triangleWave(float p_14157_, float p_14158_) {
        return (Math.abs(p_14157_ % p_14158_ - p_14158_ * 0.5f) - p_14158_ * 0.25f) / (p_14158_ * 0.25f);
    }

    public static float square(float pValue) {
        return pValue * pValue;
    }

    public static double square(double pValue) {
        return pValue * pValue;
    }

    public static int square(int pValue) {
        return pValue * pValue;
    }

    public static long square(long pValue) {
        return pValue * pValue;
    }

    public static double clampedMap(double p_144852_, double p_144853_, double p_144854_, double p_144855_, double p_144856_) {
        return Mth.clampedLerp(p_144855_, p_144856_, Mth.inverseLerp(p_144852_, p_144853_, p_144854_));
    }

    public static float clampedMap(float p_184632_, float p_184633_, float p_184634_, float p_184635_, float p_184636_) {
        return Mth.clampedLerp(p_184635_, p_184636_, Mth.inverseLerp(p_184632_, p_184633_, p_184634_));
    }

    public static double map(double p_144915_, double p_144916_, double p_144917_, double p_144918_, double p_144919_) {
        return Mth.lerp(Mth.inverseLerp(p_144915_, p_144916_, p_144917_), p_144918_, p_144919_);
    }

    public static float map(float p_184638_, float p_184639_, float p_184640_, float p_184641_, float p_184642_) {
        return Mth.lerp(Mth.inverseLerp(p_184638_, p_184639_, p_184640_), p_184641_, p_184642_);
    }

    public static double wobble(double p_144955_) {
        return p_144955_ + (2.0 * new Random(Mth.floor(p_144955_ * 3000.0)).nextDouble() - 1.0) * 1.0E-7 / 2.0;
    }

    public static int roundToward(int p_144942_, int p_144943_) {
        return Mth.positiveCeilDiv(p_144942_, p_144943_) * p_144943_;
    }

    public static int positiveCeilDiv(int p_184653_, int p_184654_) {
        return -Math.floorDiv(-p_184653_, p_184654_);
    }

    public static int randomBetweenInclusive(Random p_144929_, int p_144930_, int p_144931_) {
        return p_144929_.nextInt(p_144931_ - p_144930_ + 1) + p_144930_;
    }

    public static float randomBetween(Random p_144925_, float p_144926_, float p_144927_) {
        return p_144925_.nextFloat() * (p_144927_ - p_144926_) + p_144926_;
    }

    public static float normal(Random p_144936_, float p_144937_, float p_144938_) {
        return p_144937_ + (float)p_144936_.nextGaussian() * p_144938_;
    }

    public static double lengthSquared(double p_211590_, double p_211591_) {
        return p_211590_ * p_211590_ + p_211591_ * p_211591_;
    }

    public static double length(double p_184646_, double p_184647_) {
        return Math.sqrt(Mth.lengthSquared(p_184646_, p_184647_));
    }

    public static double lengthSquared(double p_211593_, double p_211594_, double p_211595_) {
        return p_211593_ * p_211593_ + p_211594_ * p_211594_ + p_211595_ * p_211595_;
    }

    public static double length(double p_184649_, double p_184650_, double p_184651_) {
        return Math.sqrt(Mth.lengthSquared(p_184649_, p_184650_, p_184651_));
    }

    public static int quantize(double p_184629_, int p_184630_) {
        return Mth.floor(p_184629_ / (double)p_184630_) * p_184630_;
    }
}

