/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.BitStorage;
import org.apache.commons.lang3.Validate;

public class SimpleBitStorage
implements BitStorage {
    private static final int[] MAGIC;
    private final long[] data;
    private final int bits;
    private final long mask;
    private final int size;
    private final int valuesPerLong;
    private final int divideMul;
    private final int divideAdd;
    private final int divideShift;

    static {
        int[] nArray = new int[192];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[3] = Integer.MIN_VALUE;
        nArray[6] = 0x55555555;
        nArray[7] = 0x55555555;
        nArray[9] = Integer.MIN_VALUE;
        nArray[11] = 1;
        nArray[12] = 0x33333333;
        nArray[13] = 0x33333333;
        nArray[15] = 0x2AAAAAAA;
        nArray[16] = 0x2AAAAAAA;
        nArray[18] = 0x24924924;
        nArray[19] = 0x24924924;
        nArray[21] = Integer.MIN_VALUE;
        nArray[23] = 2;
        nArray[24] = 0x1C71C71C;
        nArray[25] = 0x1C71C71C;
        nArray[27] = 0x19999999;
        nArray[28] = 0x19999999;
        nArray[30] = 390451572;
        nArray[31] = 390451572;
        nArray[33] = 0x15555555;
        nArray[34] = 0x15555555;
        nArray[36] = 0x13B13B13;
        nArray[37] = 0x13B13B13;
        nArray[39] = 306783378;
        nArray[40] = 306783378;
        nArray[42] = 0x11111111;
        nArray[43] = 0x11111111;
        nArray[45] = Integer.MIN_VALUE;
        nArray[47] = 3;
        nArray[48] = 0xF0F0F0F;
        nArray[49] = 0xF0F0F0F;
        nArray[51] = 0xE38E38E;
        nArray[52] = 0xE38E38E;
        nArray[54] = 226050910;
        nArray[55] = 226050910;
        nArray[57] = 0xCCCCCCC;
        nArray[58] = 0xCCCCCCC;
        nArray[60] = 0xC30C30C;
        nArray[61] = 0xC30C30C;
        nArray[63] = 195225786;
        nArray[64] = 195225786;
        nArray[66] = 186737708;
        nArray[67] = 186737708;
        nArray[69] = 0xAAAAAAA;
        nArray[70] = 0xAAAAAAA;
        nArray[72] = 171798691;
        nArray[73] = 171798691;
        nArray[75] = 0x9D89D89;
        nArray[76] = 0x9D89D89;
        nArray[78] = 159072862;
        nArray[79] = 159072862;
        nArray[81] = 0x9249249;
        nArray[82] = 0x9249249;
        nArray[84] = 148102320;
        nArray[85] = 148102320;
        nArray[87] = 0x8888888;
        nArray[88] = 0x8888888;
        nArray[90] = 138547332;
        nArray[91] = 138547332;
        nArray[93] = Integer.MIN_VALUE;
        nArray[95] = 4;
        nArray[96] = 130150524;
        nArray[97] = 130150524;
        nArray[99] = 0x7878787;
        nArray[100] = 0x7878787;
        nArray[102] = 0x7507507;
        nArray[103] = 0x7507507;
        nArray[105] = 0x71C71C7;
        nArray[106] = 0x71C71C7;
        nArray[108] = 116080197;
        nArray[109] = 116080197;
        nArray[111] = 113025455;
        nArray[112] = 113025455;
        nArray[114] = 0x6906906;
        nArray[115] = 0x6906906;
        nArray[117] = 0x6666666;
        nArray[118] = 0x6666666;
        nArray[120] = 104755299;
        nArray[121] = 104755299;
        nArray[123] = 0x6186186;
        nArray[124] = 0x6186186;
        nArray[126] = 99882960;
        nArray[127] = 99882960;
        nArray[129] = 97612893;
        nArray[130] = 97612893;
        nArray[132] = 0x5B05B05;
        nArray[133] = 0x5B05B05;
        nArray[135] = 93368854;
        nArray[136] = 93368854;
        nArray[138] = 91382282;
        nArray[139] = 91382282;
        nArray[141] = 0x5555555;
        nArray[142] = 0x5555555;
        nArray[144] = 87652393;
        nArray[145] = 87652393;
        nArray[147] = 85899345;
        nArray[148] = 85899345;
        nArray[150] = 0x5050505;
        nArray[151] = 0x5050505;
        nArray[153] = 0x4EC4EC4;
        nArray[154] = 0x4EC4EC4;
        nArray[156] = 81037118;
        nArray[157] = 81037118;
        nArray[159] = 79536431;
        nArray[160] = 79536431;
        nArray[162] = 78090314;
        nArray[163] = 78090314;
        nArray[165] = 0x4924924;
        nArray[166] = 0x4924924;
        nArray[168] = 75350303;
        nArray[169] = 75350303;
        nArray[171] = 74051160;
        nArray[172] = 74051160;
        nArray[174] = 72796055;
        nArray[175] = 72796055;
        nArray[177] = 0x4444444;
        nArray[178] = 0x4444444;
        nArray[180] = 70409299;
        nArray[181] = 70409299;
        nArray[183] = 69273666;
        nArray[184] = 69273666;
        nArray[186] = 0x4104104;
        nArray[187] = 0x4104104;
        nArray[189] = Integer.MIN_VALUE;
        nArray[191] = 5;
        MAGIC = nArray;
    }

    public SimpleBitStorage(int p_198164_, int p_198165_, int[] p_198166_) {
        this(p_198164_, p_198165_);
        int j = 0;
        int i = 0;
        while (i <= p_198165_ - this.valuesPerLong) {
            long k = 0L;
            int i1 = this.valuesPerLong - 1;
            while (i1 >= 0) {
                k <<= p_198164_;
                k |= (long)p_198166_[i + i1] & this.mask;
                --i1;
            }
            this.data[j++] = k;
            i += this.valuesPerLong;
        }
        int k1 = p_198165_ - i;
        if (k1 > 0) {
            long l = 0L;
            int j1 = k1 - 1;
            while (j1 >= 0) {
                l <<= p_198164_;
                l |= (long)p_198166_[i + j1] & this.mask;
                --j1;
            }
            this.data[j] = l;
        }
    }

    public SimpleBitStorage(int p_184717_, int p_184718_) {
        this(p_184717_, p_184718_, (long[])null);
    }

    public SimpleBitStorage(int p_184724_, int p_184725_, @Nullable long[] p_184726_) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)p_184724_);
        this.size = p_184725_;
        this.bits = p_184724_;
        this.mask = (1L << p_184724_) - 1L;
        this.valuesPerLong = (char)(64 / p_184724_);
        int i = 3 * (this.valuesPerLong - 1);
        this.divideMul = MAGIC[i + 0];
        this.divideAdd = MAGIC[i + 1];
        this.divideShift = MAGIC[i + 2];
        int j = (p_184725_ + this.valuesPerLong - 1) / this.valuesPerLong;
        if (p_184726_ != null) {
            if (p_184726_.length != j) {
                throw new InitializationException("Invalid length given for storage, got: " + p_184726_.length + " but expected: " + j);
            }
            this.data = p_184726_;
        } else {
            this.data = new long[j];
        }
    }

    private int cellIndex(int p_184740_) {
        long i = Integer.toUnsignedLong(this.divideMul);
        long j = Integer.toUnsignedLong(this.divideAdd);
        return (int)((long)p_184740_ * i + j >> 32 >> this.divideShift);
    }

    @Override
    public int getAndSet(int p_184731_, int p_184732_) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)p_184731_);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)p_184732_);
        int i = this.cellIndex(p_184731_);
        long j = this.data[i];
        int k = (p_184731_ - i * this.valuesPerLong) * this.bits;
        int l = (int)(j >> k & this.mask);
        this.data[i] = j & (this.mask << k ^ 0xFFFFFFFFFFFFFFFFL) | ((long)p_184732_ & this.mask) << k;
        return l;
    }

    @Override
    public void set(int p_184742_, int p_184743_) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)p_184742_);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)p_184743_);
        int i = this.cellIndex(p_184742_);
        long j = this.data[i];
        int k = (p_184742_ - i * this.valuesPerLong) * this.bits;
        this.data[i] = j & (this.mask << k ^ 0xFFFFFFFFFFFFFFFFL) | ((long)p_184743_ & this.mask) << k;
    }

    @Override
    public int get(int p_184729_) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)p_184729_);
        int i = this.cellIndex(p_184729_);
        long j = this.data[i];
        int k = (p_184729_ - i * this.valuesPerLong) * this.bits;
        return (int)(j >> k & this.mask);
    }

    @Override
    public long[] getRaw() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void getAll(IntConsumer p_184734_) {
        int i = 0;
        long[] lArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            long j = lArray[n2];
            int k = 0;
            while (k < this.valuesPerLong) {
                p_184734_.accept((int)(j & this.mask));
                j >>= this.bits;
                if (++i >= this.size) {
                    return;
                }
                ++k;
            }
            ++n2;
        }
    }

    @Override
    public void a(int[] p_198168_) {
        int i = this.data.length;
        int j = 0;
        int k = 0;
        while (k < i - 1) {
            long l = this.data[k];
            int i1 = 0;
            while (i1 < this.valuesPerLong) {
                p_198168_[j + i1] = (int)(l & this.mask);
                l >>= this.bits;
                ++i1;
            }
            j += this.valuesPerLong;
            ++k;
        }
        int j1 = this.size - j;
        if (j1 > 0) {
            long k1 = this.data[i - 1];
            int l1 = 0;
            while (l1 < j1) {
                p_198168_[j + l1] = (int)(k1 & this.mask);
                k1 >>= this.bits;
                ++l1;
            }
        }
    }

    @Override
    public BitStorage copy() {
        return new SimpleBitStorage(this.bits, this.size, (long[])this.data.clone());
    }

    public static class InitializationException
    extends RuntimeException {
        InitializationException(String p_184746_) {
            super(p_184746_);
        }
    }
}

