/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.AdvancementsFix;
import net.minecraft.util.datafix.fixes.AdvancementsRenameFix;
import net.minecraft.util.datafix.fixes.AttributesRename;
import net.minecraft.util.datafix.fixes.BedItemColorFix;
import net.minecraft.util.datafix.fixes.BeehivePoiRenameFix;
import net.minecraft.util.datafix.fixes.BiomeFix;
import net.minecraft.util.datafix.fixes.BitStorageAlignFix;
import net.minecraft.util.datafix.fixes.BlockEntityBannerColorFix;
import net.minecraft.util.datafix.fixes.BlockEntityBlockStateFix;
import net.minecraft.util.datafix.fixes.BlockEntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.BlockEntityIdFix;
import net.minecraft.util.datafix.fixes.BlockEntityJukeboxFix;
import net.minecraft.util.datafix.fixes.BlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.BlockEntityShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.BlockEntityUUIDFix;
import net.minecraft.util.datafix.fixes.BlockNameFlatteningFix;
import net.minecraft.util.datafix.fixes.BlockRenameFix;
import net.minecraft.util.datafix.fixes.BlockRenameFixWithJigsaw;
import net.minecraft.util.datafix.fixes.BlockStateStructureTemplateFix;
import net.minecraft.util.datafix.fixes.CatTypeFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChunkBedBlockEntityInjecterFix;
import net.minecraft.util.datafix.fixes.ChunkBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkLightRemoveFix;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix2;
import net.minecraft.util.datafix.fixes.ChunkStructuresTemplateRenameFix;
import net.minecraft.util.datafix.fixes.ChunkToProtochunkFix;
import net.minecraft.util.datafix.fixes.ColorlessShulkerEntityFix;
import net.minecraft.util.datafix.fixes.DyeItemRenameFix;
import net.minecraft.util.datafix.fixes.EntityArmorStandSilentFix;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.EntityCatSplitFix;
import net.minecraft.util.datafix.fixes.EntityCodSalmonFix;
import net.minecraft.util.datafix.fixes.EntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.EntityElderGuardianSplitFix;
import net.minecraft.util.datafix.fixes.EntityEquipmentToArmorAndHandFix;
import net.minecraft.util.datafix.fixes.EntityHealthFix;
import net.minecraft.util.datafix.fixes.EntityHorseSaddleFix;
import net.minecraft.util.datafix.fixes.EntityHorseSplitFix;
import net.minecraft.util.datafix.fixes.EntityIdFix;
import net.minecraft.util.datafix.fixes.EntityItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityMinecartIdentifiersFix;
import net.minecraft.util.datafix.fixes.EntityPaintingItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityPaintingMotiveFix;
import net.minecraft.util.datafix.fixes.EntityProjectileOwnerFix;
import net.minecraft.util.datafix.fixes.EntityPufferfishRenameFix;
import net.minecraft.util.datafix.fixes.EntityRavagerRenameFix;
import net.minecraft.util.datafix.fixes.EntityRedundantChanceTagsFix;
import net.minecraft.util.datafix.fixes.EntityRidingToPassengersFix;
import net.minecraft.util.datafix.fixes.EntityShulkerColorFix;
import net.minecraft.util.datafix.fixes.EntityShulkerRotationFix;
import net.minecraft.util.datafix.fixes.EntitySkeletonSplitFix;
import net.minecraft.util.datafix.fixes.EntityStringUuidFix;
import net.minecraft.util.datafix.fixes.EntityTheRenameningFix;
import net.minecraft.util.datafix.fixes.EntityTippedArrowFix;
import net.minecraft.util.datafix.fixes.EntityUUIDFix;
import net.minecraft.util.datafix.fixes.EntityWolfColorFix;
import net.minecraft.util.datafix.fixes.EntityZombieSplitFix;
import net.minecraft.util.datafix.fixes.EntityZombieVillagerTypeFix;
import net.minecraft.util.datafix.fixes.EntityZombifiedPiglinRenameFix;
import net.minecraft.util.datafix.fixes.ForcePoiRebuild;
import net.minecraft.util.datafix.fixes.FurnaceRecipeFix;
import net.minecraft.util.datafix.fixes.GossipUUIDFix;
import net.minecraft.util.datafix.fixes.HeightmapRenamingFix;
import net.minecraft.util.datafix.fixes.IglooMetadataRemovalFix;
import net.minecraft.util.datafix.fixes.ItemBannerColorFix;
import net.minecraft.util.datafix.fixes.ItemCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemLoreFix;
import net.minecraft.util.datafix.fixes.ItemPotionFix;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.ItemShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.ItemSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackEnchantmentNamesFix;
import net.minecraft.util.datafix.fixes.ItemStackMapIdFix;
import net.minecraft.util.datafix.fixes.ItemStackSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.util.datafix.fixes.ItemStackUUIDFix;
import net.minecraft.util.datafix.fixes.ItemWaterPotionFix;
import net.minecraft.util.datafix.fixes.ItemWrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.fixes.JigsawPropertiesFix;
import net.minecraft.util.datafix.fixes.JigsawRotationFix;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.LevelDataGeneratorOptionsFix;
import net.minecraft.util.datafix.fixes.LevelFlatGeneratorInfoFix;
import net.minecraft.util.datafix.fixes.LevelUUIDFix;
import net.minecraft.util.datafix.fixes.MapIdFix;
import net.minecraft.util.datafix.fixes.MemoryExpiryDataFix;
import net.minecraft.util.datafix.fixes.MissingDimensionFix;
import net.minecraft.util.datafix.fixes.MobSpawnerEntityIdentifiersFix;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.NewVillageFix;
import net.minecraft.util.datafix.fixes.ObjectiveDisplayNameFix;
import net.minecraft.util.datafix.fixes.ObjectiveRenderTypeFix;
import net.minecraft.util.datafix.fixes.OminousBannerBlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRenameFix;
import net.minecraft.util.datafix.fixes.OptionsAddTextBackgroundFix;
import net.minecraft.util.datafix.fixes.OptionsForceVBOFix;
import net.minecraft.util.datafix.fixes.OptionsKeyLwjgl3Fix;
import net.minecraft.util.datafix.fixes.OptionsKeyTranslationFix;
import net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguageFix;
import net.minecraft.util.datafix.fixes.OptionsRenameFieldFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.PlayerUUIDFix;
import net.minecraft.util.datafix.fixes.RecipesFix;
import net.minecraft.util.datafix.fixes.RecipesRenameFix;
import net.minecraft.util.datafix.fixes.RecipesRenameningFix;
import net.minecraft.util.datafix.fixes.RedstoneWireConnectionsFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.RemoveGolemGossipFix;
import net.minecraft.util.datafix.fixes.RenameBiomesFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFansFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFix;
import net.minecraft.util.datafix.fixes.ReorganizePoi;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SavedDataUUIDFix;
import net.minecraft.util.datafix.fixes.SavedDataVillageCropFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsCounterFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StriderGravityFix;
import net.minecraft.util.datafix.fixes.StructureReferenceCountFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TeamDisplayNameFix;
import net.minecraft.util.datafix.fixes.TrappedChestBlockEntityFix;
import net.minecraft.util.datafix.fixes.VillagerDataFix;
import net.minecraft.util.datafix.fixes.VillagerFollowRangeFix;
import net.minecraft.util.datafix.fixes.VillagerRebuildLevelAndXpFix;
import net.minecraft.util.datafix.fixes.VillagerTradeFix;
import net.minecraft.util.datafix.fixes.WallPropertyFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WriteAndReadFix;
import net.minecraft.util.datafix.fixes.ZombieVillagerRebuildXpFix;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.util.datafix.schemas.V100;
import net.minecraft.util.datafix.schemas.V102;
import net.minecraft.util.datafix.schemas.V1022;
import net.minecraft.util.datafix.schemas.V106;
import net.minecraft.util.datafix.schemas.V107;
import net.minecraft.util.datafix.schemas.V1125;
import net.minecraft.util.datafix.schemas.V135;
import net.minecraft.util.datafix.schemas.V143;
import net.minecraft.util.datafix.schemas.V1451;
import net.minecraft.util.datafix.schemas.V1451_1;
import net.minecraft.util.datafix.schemas.V1451_2;
import net.minecraft.util.datafix.schemas.V1451_3;
import net.minecraft.util.datafix.schemas.V1451_4;
import net.minecraft.util.datafix.schemas.V1451_5;
import net.minecraft.util.datafix.schemas.V1451_6;
import net.minecraft.util.datafix.schemas.V1451_7;
import net.minecraft.util.datafix.schemas.V1460;
import net.minecraft.util.datafix.schemas.V1466;
import net.minecraft.util.datafix.schemas.V1470;
import net.minecraft.util.datafix.schemas.V1481;
import net.minecraft.util.datafix.schemas.V1483;
import net.minecraft.util.datafix.schemas.V1486;
import net.minecraft.util.datafix.schemas.V1510;
import net.minecraft.util.datafix.schemas.V1800;
import net.minecraft.util.datafix.schemas.V1801;
import net.minecraft.util.datafix.schemas.V1904;
import net.minecraft.util.datafix.schemas.V1906;
import net.minecraft.util.datafix.schemas.V1909;
import net.minecraft.util.datafix.schemas.V1920;
import net.minecraft.util.datafix.schemas.V1928;
import net.minecraft.util.datafix.schemas.V1929;
import net.minecraft.util.datafix.schemas.V1931;
import net.minecraft.util.datafix.schemas.V2100;
import net.minecraft.util.datafix.schemas.V2501;
import net.minecraft.util.datafix.schemas.V2502;
import net.minecraft.util.datafix.schemas.V2505;
import net.minecraft.util.datafix.schemas.V2509;
import net.minecraft.util.datafix.schemas.V2519;
import net.minecraft.util.datafix.schemas.V2522;
import net.minecraft.util.datafix.schemas.V2551;
import net.minecraft.util.datafix.schemas.V2568;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V501;
import net.minecraft.util.datafix.schemas.V700;
import net.minecraft.util.datafix.schemas.V701;
import net.minecraft.util.datafix.schemas.V702;
import net.minecraft.util.datafix.schemas.V703;
import net.minecraft.util.datafix.schemas.V704;
import net.minecraft.util.datafix.schemas.V705;
import net.minecraft.util.datafix.schemas.V808;
import net.minecraft.util.datafix.schemas.V99;

public class DataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;
    private static final DataFixer DATA_FIXER = DataFixers.createFixerUpper();

    private static DataFixer createFixerUpper() {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.getCurrentVersion().getWorldVersion());
        DataFixers.addFixers(datafixerbuilder);
        return datafixerbuilder.build((Executor)Util.bootstrapExecutor());
    }

    public static DataFixer getDataFixer() {
        return DATA_FIXER;
    }

    private static void addFixers(DataFixerBuilder pBuilder) {
        Schema schema = pBuilder.addSchema(99, V99::new);
        Schema schema1 = pBuilder.addSchema(100, V100::new);
        pBuilder.addFixer((DataFix)new EntityEquipmentToArmorAndHandFix(schema1, true));
        Schema schema2 = pBuilder.addSchema(101, SAME);
        pBuilder.addFixer((DataFix)new BlockEntitySignTextStrictJsonFix(schema2, false));
        Schema schema3 = pBuilder.addSchema(102, V102::new);
        pBuilder.addFixer((DataFix)new ItemIdFix(schema3, true));
        pBuilder.addFixer((DataFix)new ItemPotionFix(schema3, false));
        Schema schema4 = pBuilder.addSchema(105, SAME);
        pBuilder.addFixer((DataFix)new ItemSpawnEggFix(schema4, true));
        Schema schema5 = pBuilder.addSchema(106, V106::new);
        pBuilder.addFixer((DataFix)new MobSpawnerEntityIdentifiersFix(schema5, true));
        Schema schema6 = pBuilder.addSchema(107, V107::new);
        pBuilder.addFixer((DataFix)new EntityMinecartIdentifiersFix(schema6, true));
        Schema schema7 = pBuilder.addSchema(108, SAME);
        pBuilder.addFixer((DataFix)new EntityStringUuidFix(schema7, true));
        Schema schema8 = pBuilder.addSchema(109, SAME);
        pBuilder.addFixer((DataFix)new EntityHealthFix(schema8, true));
        Schema schema9 = pBuilder.addSchema(110, SAME);
        pBuilder.addFixer((DataFix)new EntityHorseSaddleFix(schema9, true));
        Schema schema10 = pBuilder.addSchema(111, SAME);
        pBuilder.addFixer((DataFix)new EntityPaintingItemFrameDirectionFix(schema10, true));
        Schema schema11 = pBuilder.addSchema(113, SAME);
        pBuilder.addFixer((DataFix)new EntityRedundantChanceTagsFix(schema11, true));
        Schema schema12 = pBuilder.addSchema(135, V135::new);
        pBuilder.addFixer((DataFix)new EntityRidingToPassengersFix(schema12, true));
        Schema schema13 = pBuilder.addSchema(143, V143::new);
        pBuilder.addFixer((DataFix)new EntityTippedArrowFix(schema13, true));
        Schema schema14 = pBuilder.addSchema(147, SAME);
        pBuilder.addFixer((DataFix)new EntityArmorStandSilentFix(schema14, true));
        Schema schema15 = pBuilder.addSchema(165, SAME);
        pBuilder.addFixer((DataFix)new ItemWrittenBookPagesStrictJsonFix(schema15, true));
        Schema schema16 = pBuilder.addSchema(501, V501::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema16, "Add 1.10 entities fix", References.ENTITY));
        Schema schema17 = pBuilder.addSchema(502, SAME);
        pBuilder.addFixer(ItemRenameFix.create(schema17, "cooked_fished item renamer", p_14533_ -> Objects.equals(NamespacedSchema.ensureNamespaced(p_14533_), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : p_14533_));
        pBuilder.addFixer((DataFix)new EntityZombieVillagerTypeFix(schema17, false));
        Schema schema18 = pBuilder.addSchema(505, SAME);
        pBuilder.addFixer((DataFix)new OptionsForceVBOFix(schema18, false));
        Schema schema19 = pBuilder.addSchema(700, V700::new);
        pBuilder.addFixer((DataFix)new EntityElderGuardianSplitFix(schema19, true));
        Schema schema20 = pBuilder.addSchema(701, V701::new);
        pBuilder.addFixer((DataFix)new EntitySkeletonSplitFix(schema20, true));
        Schema schema21 = pBuilder.addSchema(702, V702::new);
        pBuilder.addFixer((DataFix)new EntityZombieSplitFix(schema21, true));
        Schema schema22 = pBuilder.addSchema(703, V703::new);
        pBuilder.addFixer((DataFix)new EntityHorseSplitFix(schema22, true));
        Schema schema23 = pBuilder.addSchema(704, V704::new);
        pBuilder.addFixer((DataFix)new BlockEntityIdFix(schema23, true));
        Schema schema24 = pBuilder.addSchema(705, V705::new);
        pBuilder.addFixer((DataFix)new EntityIdFix(schema24, true));
        Schema schema25 = pBuilder.addSchema(804, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ItemBannerColorFix(schema25, true));
        Schema schema26 = pBuilder.addSchema(806, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ItemWaterPotionFix(schema26, false));
        Schema schema27 = pBuilder.addSchema(808, V808::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema27, "added shulker box", References.BLOCK_ENTITY));
        Schema schema28 = pBuilder.addSchema(808, 1, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new EntityShulkerColorFix(schema28, false));
        Schema schema29 = pBuilder.addSchema(813, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ItemShulkerBoxColorFix(schema29, false));
        pBuilder.addFixer((DataFix)new BlockEntityShulkerBoxColorFix(schema29, false));
        Schema schema30 = pBuilder.addSchema(816, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OptionsLowerCaseLanguageFix(schema30, false));
        Schema schema31 = pBuilder.addSchema(820, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema31, "totem item renamer", DataFixers.createRenamer("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema32 = pBuilder.addSchema(1022, V1022::new);
        pBuilder.addFixer((DataFix)new WriteAndReadFix(schema32, "added shoulder entities to players", References.PLAYER));
        Schema schema33 = pBuilder.addSchema(1125, V1125::new);
        pBuilder.addFixer((DataFix)new ChunkBedBlockEntityInjecterFix(schema33, true));
        pBuilder.addFixer((DataFix)new BedItemColorFix(schema33, false));
        Schema schema34 = pBuilder.addSchema(1344, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OptionsKeyLwjgl3Fix(schema34, false));
        Schema schema35 = pBuilder.addSchema(1446, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OptionsKeyTranslationFix(schema35, false));
        Schema schema36 = pBuilder.addSchema(1450, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new BlockStateStructureTemplateFix(schema36, false));
        Schema schema37 = pBuilder.addSchema(1451, V1451::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema37, "AddTrappedChestFix", References.BLOCK_ENTITY));
        Schema schema38 = pBuilder.addSchema(1451, 1, V1451_1::new);
        pBuilder.addFixer((DataFix)new ChunkPalettedStorageFix(schema38, true));
        Schema schema39 = pBuilder.addSchema(1451, 2, V1451_2::new);
        pBuilder.addFixer((DataFix)new BlockEntityBlockStateFix(schema39, true));
        Schema schema40 = pBuilder.addSchema(1451, 3, V1451_3::new);
        pBuilder.addFixer((DataFix)new EntityBlockStateFix(schema40, true));
        pBuilder.addFixer((DataFix)new ItemStackMapIdFix(schema40, false));
        Schema schema41 = pBuilder.addSchema(1451, 4, V1451_4::new);
        pBuilder.addFixer((DataFix)new BlockNameFlatteningFix(schema41, true));
        pBuilder.addFixer((DataFix)new ItemStackTheFlatteningFix(schema41, false));
        Schema schema42 = pBuilder.addSchema(1451, 5, V1451_5::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema42, "RemoveNoteBlockFlowerPotFix", References.BLOCK_ENTITY));
        pBuilder.addFixer((DataFix)new ItemStackSpawnEggFix(schema42, false));
        pBuilder.addFixer((DataFix)new EntityWolfColorFix(schema42, false));
        pBuilder.addFixer((DataFix)new BlockEntityBannerColorFix(schema42, false));
        pBuilder.addFixer((DataFix)new LevelFlatGeneratorInfoFix(schema42, false));
        Schema schema43 = pBuilder.addSchema(1451, 6, V1451_6::new);
        pBuilder.addFixer((DataFix)new StatsCounterFix(schema43, true));
        pBuilder.addFixer((DataFix)new WriteAndReadFix(schema43, "Rewrite objectives", References.OBJECTIVE));
        pBuilder.addFixer((DataFix)new BlockEntityJukeboxFix(schema43, false));
        Schema schema44 = pBuilder.addSchema(1451, 7, V1451_7::new);
        pBuilder.addFixer((DataFix)new SavedDataVillageCropFix(schema44, true));
        Schema schema45 = pBuilder.addSchema(1451, 7, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new VillagerTradeFix(schema45, false));
        Schema schema46 = pBuilder.addSchema(1456, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new EntityItemFrameDirectionFix(schema46, false));
        Schema schema47 = pBuilder.addSchema(1458, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new EntityCustomNameToComponentFix(schema47, false));
        pBuilder.addFixer((DataFix)new ItemCustomNameToComponentFix(schema47, false));
        pBuilder.addFixer((DataFix)new BlockEntityCustomNameToComponentFix(schema47, false));
        Schema schema48 = pBuilder.addSchema(1460, V1460::new);
        pBuilder.addFixer((DataFix)new EntityPaintingMotiveFix(schema48, false));
        Schema schema49 = pBuilder.addSchema(1466, V1466::new);
        pBuilder.addFixer((DataFix)new ChunkToProtochunkFix(schema49, true));
        Schema schema50 = pBuilder.addSchema(1470, V1470::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema50, "Add 1.13 entities fix", References.ENTITY));
        Schema schema51 = pBuilder.addSchema(1474, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ColorlessShulkerEntityFix(schema51, false));
        pBuilder.addFixer(BlockRenameFix.create(schema51, "Colorless shulker block fixer", p_14531_ -> Objects.equals(NamespacedSchema.ensureNamespaced(p_14531_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_14531_));
        pBuilder.addFixer(ItemRenameFix.create(schema51, "Colorless shulker item fixer", p_14516_ -> Objects.equals(NamespacedSchema.ensureNamespaced(p_14516_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_14516_));
        Schema schema52 = pBuilder.addSchema(1475, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFix.create(schema52, "Flowing fixer", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema53 = pBuilder.addSchema(1480, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFix.create(schema53, "Rename coral blocks", DataFixers.createRenamer(RenamedCoralFix.RENAMED_IDS)));
        pBuilder.addFixer(ItemRenameFix.create(schema53, "Rename coral items", DataFixers.createRenamer(RenamedCoralFix.RENAMED_IDS)));
        Schema schema54 = pBuilder.addSchema(1481, V1481::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema54, "Add conduit", References.BLOCK_ENTITY));
        Schema schema55 = pBuilder.addSchema(1483, V1483::new);
        pBuilder.addFixer((DataFix)new EntityPufferfishRenameFix(schema55, true));
        pBuilder.addFixer(ItemRenameFix.create(schema55, "Rename pufferfish egg item", DataFixers.createRenamer(EntityPufferfishRenameFix.RENAMED_IDS)));
        Schema schema56 = pBuilder.addSchema(1484, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema56, "Rename seagrass items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        pBuilder.addFixer(BlockRenameFix.create(schema56, "Rename seagrass blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        pBuilder.addFixer((DataFix)new HeightmapRenamingFix(schema56, false));
        Schema schema57 = pBuilder.addSchema(1486, V1486::new);
        pBuilder.addFixer((DataFix)new EntityCodSalmonFix(schema57, true));
        pBuilder.addFixer(ItemRenameFix.create(schema57, "Rename cod/salmon egg items", DataFixers.createRenamer(EntityCodSalmonFix.RENAMED_EGG_IDS)));
        Schema schema58 = pBuilder.addSchema(1487, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema58, "Rename prismarine_brick(s)_* blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        pBuilder.addFixer(BlockRenameFix.create(schema58, "Rename prismarine_brick(s)_* items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema59 = pBuilder.addSchema(1488, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFix.create(schema59, "Rename kelp/kelptop", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        pBuilder.addFixer(ItemRenameFix.create(schema59, "Rename kelptop", DataFixers.createRenamer("minecraft:kelp_top", "minecraft:kelp")));
        pBuilder.addFixer((DataFix)new NamedEntityFix(schema59, false, "Command block block entity custom name fix", References.BLOCK_ENTITY, "minecraft:command_block"){

            @Override
            protected Typed<?> fix(Typed<?> p_14541_) {
                return p_14541_.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::fixTagCustomName);
            }
        });
        pBuilder.addFixer((DataFix)new NamedEntityFix(schema59, false, "Command block minecart custom name fix", References.ENTITY, "minecraft:commandblock_minecart"){

            @Override
            protected Typed<?> fix(Typed<?> p_14549_) {
                return p_14549_.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::fixTagCustomName);
            }
        });
        pBuilder.addFixer((DataFix)new IglooMetadataRemovalFix(schema59, false));
        Schema schema60 = pBuilder.addSchema(1490, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFix.create(schema60, "Rename melon_block", DataFixers.createRenamer("minecraft:melon_block", "minecraft:melon")));
        pBuilder.addFixer(ItemRenameFix.create(schema60, "Rename melon_block/melon/speckled_melon", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema61 = pBuilder.addSchema(1492, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ChunkStructuresTemplateRenameFix(schema61, false));
        Schema schema62 = pBuilder.addSchema(1494, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ItemStackEnchantmentNamesFix(schema62, false));
        Schema schema63 = pBuilder.addSchema(1496, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new LeavesFix(schema63, false));
        Schema schema64 = pBuilder.addSchema(1500, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new BlockEntityKeepPacked(schema64, false));
        Schema schema65 = pBuilder.addSchema(1501, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new AdvancementsFix(schema65, false));
        Schema schema66 = pBuilder.addSchema(1502, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new RecipesFix(schema66, false));
        Schema schema67 = pBuilder.addSchema(1506, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new LevelDataGeneratorOptionsFix(schema67, false));
        Schema schema68 = pBuilder.addSchema(1510, V1510::new);
        pBuilder.addFixer(BlockRenameFix.create(schema68, "Block renamening fix", DataFixers.createRenamer(EntityTheRenameningFix.RENAMED_BLOCKS)));
        pBuilder.addFixer(ItemRenameFix.create(schema68, "Item renamening fix", DataFixers.createRenamer(EntityTheRenameningFix.RENAMED_ITEMS)));
        pBuilder.addFixer((DataFix)new RecipesRenameningFix(schema68, false));
        pBuilder.addFixer((DataFix)new EntityTheRenameningFix(schema68, true));
        pBuilder.addFixer((DataFix)new StatsRenameFix(schema68, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema69 = pBuilder.addSchema(1514, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ObjectiveDisplayNameFix(schema69, false));
        pBuilder.addFixer((DataFix)new TeamDisplayNameFix(schema69, false));
        pBuilder.addFixer((DataFix)new ObjectiveRenderTypeFix(schema69, false));
        Schema schema70 = pBuilder.addSchema(1515, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFix.create(schema70, "Rename coral fan blocks", DataFixers.createRenamer(RenamedCoralFansFix.RENAMED_IDS)));
        Schema schema71 = pBuilder.addSchema(1624, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new TrappedChestBlockEntityFix(schema71, false));
        Schema schema72 = pBuilder.addSchema(1800, V1800::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema72, "Added 1.14 mobs fix", References.ENTITY));
        pBuilder.addFixer(ItemRenameFix.create(schema72, "Rename dye items", DataFixers.createRenamer(DyeItemRenameFix.RENAMED_IDS)));
        Schema schema73 = pBuilder.addSchema(1801, V1801::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema73, "Added Illager Beast", References.ENTITY));
        Schema schema74 = pBuilder.addSchema(1802, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFix.create(schema74, "Rename sign blocks & stone slabs", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        pBuilder.addFixer(ItemRenameFix.create(schema74, "Rename sign item & stone slabs", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema75 = pBuilder.addSchema(1803, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ItemLoreFix(schema75, false));
        Schema schema76 = pBuilder.addSchema(1904, V1904::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema76, "Added Cats", References.ENTITY));
        pBuilder.addFixer((DataFix)new EntityCatSplitFix(schema76, false));
        Schema schema77 = pBuilder.addSchema(1905, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ChunkStatusFix(schema77, false));
        Schema schema78 = pBuilder.addSchema(1906, V1906::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema78, "Add POI Blocks", References.BLOCK_ENTITY));
        Schema schema79 = pBuilder.addSchema(1909, V1909::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema79, "Add jigsaw", References.BLOCK_ENTITY));
        Schema schema80 = pBuilder.addSchema(1911, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ChunkStatusFix2(schema80, false));
        Schema schema81 = pBuilder.addSchema(1914, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new WeaponSmithChestLootTableFix(schema81, false));
        Schema schema82 = pBuilder.addSchema(1917, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new CatTypeFix(schema82, false));
        Schema schema83 = pBuilder.addSchema(1918, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new VillagerDataFix(schema83, "minecraft:villager"));
        pBuilder.addFixer((DataFix)new VillagerDataFix(schema83, "minecraft:zombie_villager"));
        Schema schema84 = pBuilder.addSchema(1920, V1920::new);
        pBuilder.addFixer((DataFix)new NewVillageFix(schema84, false));
        pBuilder.addFixer((DataFix)new AddNewChoices(schema84, "Add campfire", References.BLOCK_ENTITY));
        Schema schema85 = pBuilder.addSchema(1925, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new MapIdFix(schema85, false));
        Schema schema86 = pBuilder.addSchema(1928, V1928::new);
        pBuilder.addFixer((DataFix)new EntityRavagerRenameFix(schema86, true));
        pBuilder.addFixer(ItemRenameFix.create(schema86, "Rename ravager egg item", DataFixers.createRenamer(EntityRavagerRenameFix.RENAMED_IDS)));
        Schema schema87 = pBuilder.addSchema(1929, V1929::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema87, "Add Wandering Trader and Trader Llama", References.ENTITY));
        Schema schema88 = pBuilder.addSchema(1931, V1931::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema88, "Added Fox", References.ENTITY));
        Schema schema89 = pBuilder.addSchema(1936, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OptionsAddTextBackgroundFix(schema89, false));
        Schema schema90 = pBuilder.addSchema(1946, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ReorganizePoi(schema90, false));
        Schema schema91 = pBuilder.addSchema(1948, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OminousBannerRenameFix(schema91, false));
        Schema schema92 = pBuilder.addSchema(1953, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OminousBannerBlockEntityRenameFix(schema92, false));
        Schema schema93 = pBuilder.addSchema(1955, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new VillagerRebuildLevelAndXpFix(schema93, false));
        pBuilder.addFixer((DataFix)new ZombieVillagerRebuildXpFix(schema93, false));
        Schema schema94 = pBuilder.addSchema(1961, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ChunkLightRemoveFix(schema94, false));
        Schema schema95 = pBuilder.addSchema(1963, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new RemoveGolemGossipFix(schema95, false));
        Schema schema96 = pBuilder.addSchema(2100, V2100::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema96, "Added Bee and Bee Stinger", References.ENTITY));
        pBuilder.addFixer((DataFix)new AddNewChoices(schema96, "Add beehive", References.BLOCK_ENTITY));
        pBuilder.addFixer((DataFix)new RecipesRenameFix(schema96, false, "Rename sugar recipe", DataFixers.createRenamer("minecraft:sugar", "sugar_from_sugar_cane")));
        pBuilder.addFixer((DataFix)new AdvancementsRenameFix(schema96, false, "Rename sugar recipe advancement", DataFixers.createRenamer("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema97 = pBuilder.addSchema(2202, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ChunkBiomeFix(schema97, false));
        Schema schema98 = pBuilder.addSchema(2209, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema98, "Rename bee_hive item to beehive", DataFixers.createRenamer("minecraft:bee_hive", "minecraft:beehive")));
        pBuilder.addFixer((DataFix)new BeehivePoiRenameFix(schema98));
        pBuilder.addFixer(BlockRenameFix.create(schema98, "Rename bee_hive block to beehive", DataFixers.createRenamer("minecraft:bee_hive", "minecraft:beehive")));
        Schema schema99 = pBuilder.addSchema(2211, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new StructureReferenceCountFix(schema99, false));
        Schema schema100 = pBuilder.addSchema(2218, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ForcePoiRebuild(schema100, false));
        Schema schema101 = pBuilder.addSchema(2501, V2501::new);
        pBuilder.addFixer((DataFix)new FurnaceRecipeFix(schema101, true));
        Schema schema102 = pBuilder.addSchema(2502, V2502::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema102, "Added Hoglin", References.ENTITY));
        Schema schema103 = pBuilder.addSchema(2503, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new WallPropertyFix(schema103, false));
        pBuilder.addFixer((DataFix)new AdvancementsRenameFix(schema103, false, "Composter category change", DataFixers.createRenamer("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema104 = pBuilder.addSchema(2505, V2505::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema104, "Added Piglin", References.ENTITY));
        pBuilder.addFixer((DataFix)new MemoryExpiryDataFix(schema104, "minecraft:villager"));
        Schema schema105 = pBuilder.addSchema(2508, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema105, "Renamed fungi items to fungus", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        pBuilder.addFixer(BlockRenameFix.create(schema105, "Renamed fungi blocks to fungus", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema106 = pBuilder.addSchema(2509, V2509::new);
        pBuilder.addFixer((DataFix)new EntityZombifiedPiglinRenameFix(schema106));
        pBuilder.addFixer(ItemRenameFix.create(schema106, "Rename zombie pigman egg item", DataFixers.createRenamer(EntityZombifiedPiglinRenameFix.RENAMED_IDS)));
        Schema schema107 = pBuilder.addSchema(2511, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new EntityProjectileOwnerFix(schema107));
        Schema schema108 = pBuilder.addSchema(2514, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new EntityUUIDFix(schema108));
        pBuilder.addFixer((DataFix)new BlockEntityUUIDFix(schema108));
        pBuilder.addFixer((DataFix)new PlayerUUIDFix(schema108));
        pBuilder.addFixer((DataFix)new LevelUUIDFix(schema108));
        pBuilder.addFixer((DataFix)new SavedDataUUIDFix(schema108));
        pBuilder.addFixer((DataFix)new ItemStackUUIDFix(schema108));
        Schema schema109 = pBuilder.addSchema(2516, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new GossipUUIDFix(schema109, "minecraft:villager"));
        pBuilder.addFixer((DataFix)new GossipUUIDFix(schema109, "minecraft:zombie_villager"));
        Schema schema110 = pBuilder.addSchema(2518, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new JigsawPropertiesFix(schema110, false));
        pBuilder.addFixer((DataFix)new JigsawRotationFix(schema110, false));
        Schema schema111 = pBuilder.addSchema(2519, V2519::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema111, "Added Strider", References.ENTITY));
        Schema schema112 = pBuilder.addSchema(2522, V2522::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema112, "Added Zoglin", References.ENTITY));
        Schema schema113 = pBuilder.addSchema(2523, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new AttributesRename(schema113));
        Schema schema114 = pBuilder.addSchema(2527, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new BitStorageAlignFix(schema114));
        Schema schema115 = pBuilder.addSchema(2528, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema115, "Rename soul fire torch and soul fire lantern", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        pBuilder.addFixer(BlockRenameFix.create(schema115, "Rename soul fire torch and soul fire lantern", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema116 = pBuilder.addSchema(2529, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new StriderGravityFix(schema116, false));
        Schema schema117 = pBuilder.addSchema(2531, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new RedstoneWireConnectionsFix(schema117));
        Schema schema118 = pBuilder.addSchema(2533, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new VillagerFollowRangeFix(schema118));
        Schema schema119 = pBuilder.addSchema(2535, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new EntityShulkerRotationFix(schema119));
        Schema schema120 = pBuilder.addSchema(2550, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new WorldGenSettingsFix(schema120));
        Schema schema121 = pBuilder.addSchema(2551, V2551::new);
        pBuilder.addFixer((DataFix)new WriteAndReadFix(schema121, "add types to WorldGenData", References.WORLD_GEN_SETTINGS));
        Schema schema122 = pBuilder.addSchema(2552, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new RenameBiomesFix(schema122, false, "Nether biome rename", (Map<String, String>)ImmutableMap.of((Object)"minecraft:nether", (Object)"minecraft:nether_wastes")));
        Schema schema123 = pBuilder.addSchema(2553, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new BiomeFix(schema123, false));
        Schema schema124 = pBuilder.addSchema(2558, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new MissingDimensionFix(schema124, false));
        pBuilder.addFixer((DataFix)new OptionsRenameFieldFix(schema124, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema125 = pBuilder.addSchema(2568, V2568::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema125, "Added Piglin Brute", References.ENTITY));
        Schema schema126 = pBuilder.addSchema(2571, V2571::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema126, "Added Goat", References.ENTITY));
        Schema schema127 = pBuilder.addSchema(2679, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new CauldronRenameFix(schema127, false));
        Schema schema128 = pBuilder.addSchema(2680, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema128, "Renamed grass path item to dirt path", DataFixers.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        pBuilder.addFixer(BlockRenameFixWithJigsaw.create(schema128, "Renamed grass path block to dirt path", DataFixers.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema129 = pBuilder.addSchema(2684, V2684::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema129, "Added Sculk Sensor", References.BLOCK_ENTITY));
        Schema schema130 = pBuilder.addSchema(2686, V2686::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema130, "Added Axolotl", References.ENTITY));
        Schema schema131 = pBuilder.addSchema(2688, V2688::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema131, "Added Glow Squid", References.ENTITY));
        pBuilder.addFixer((DataFix)new AddNewChoices(schema131, "Added Glow Item Frame", References.ENTITY));
        Schema schema132 = pBuilder.addSchema(2690, SAME_NAMESPACED);
        ImmutableMap immutablemap = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        pBuilder.addFixer(ItemRenameFix.create(schema132, "Renamed copper block items to new oxidized terms", DataFixers.createRenamer((Map<String, String>)immutablemap)));
        pBuilder.addFixer(BlockRenameFixWithJigsaw.create(schema132, "Renamed copper blocks to new oxidized terms", DataFixers.createRenamer((Map<String, String>)immutablemap)));
        Schema schema133 = pBuilder.addSchema(2691, SAME_NAMESPACED);
        ImmutableMap immutablemap1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        pBuilder.addFixer(ItemRenameFix.create(schema133, "Rename copper item suffixes", DataFixers.createRenamer((Map<String, String>)immutablemap1)));
        pBuilder.addFixer(BlockRenameFixWithJigsaw.create(schema133, "Rename copper blocks suffixes", DataFixers.createRenamer((Map<String, String>)immutablemap1)));
        Schema schema134 = pBuilder.addSchema(2693, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema134, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema schema135 = pBuilder.addSchema(2696, SAME_NAMESPACED);
        ImmutableMap immutablemap2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        pBuilder.addFixer(ItemRenameFix.create(schema135, "Renamed grimstone block items to deepslate", DataFixers.createRenamer((Map<String, String>)immutablemap2)));
        pBuilder.addFixer(BlockRenameFixWithJigsaw.create(schema135, "Renamed grimstone blocks to deepslate", DataFixers.createRenamer((Map<String, String>)immutablemap2)));
        Schema schema136 = pBuilder.addSchema(2700, SAME_NAMESPACED);
        pBuilder.addFixer(BlockRenameFixWithJigsaw.create(schema136, "Renamed cave vines blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema137 = pBuilder.addSchema(2701, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new SavedDataFeaturePoolElementFix(schema137));
        Schema schema138 = pBuilder.addSchema(2702, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new AbstractArrowPickupFix(schema138));
        Schema schema139 = pBuilder.addSchema(2704, V2704::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema139, "Added Goat", References.ENTITY));
        Schema schema140 = pBuilder.addSchema(2707, V2707::new);
        pBuilder.addFixer((DataFix)new AddNewChoices(schema140, "Added Marker", References.ENTITY));
        pBuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema140, References.WORLD_GEN_SETTINGS, "has_increased_height_already", true));
        Schema schema141 = pBuilder.addSchema(2710, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new StatsRenameFix(schema141, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema142 = pBuilder.addSchema(2717, SAME_NAMESPACED);
        pBuilder.addFixer(ItemRenameFix.create(schema142, "Rename azalea_leaves_flowers", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        pBuilder.addFixer(BlockRenameFix.create(schema142, "Rename azalea_leaves_flowers items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema143 = pBuilder.addSchema(2825, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema143, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema schema144 = pBuilder.addSchema(2831, V2831::new);
        pBuilder.addFixer((DataFix)new SpawnerDataFix(schema144));
        Schema schema145 = pBuilder.addSchema(2832, V2832::new);
        pBuilder.addFixer((DataFix)new WorldGenSettingsHeightAndBiomeFix(schema145));
        pBuilder.addFixer((DataFix)new ChunkHeightAndBiomeFix(schema145));
        Schema schema146 = pBuilder.addSchema(2833, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema146));
        Schema schema147 = pBuilder.addSchema(2838, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new RenameBiomesFix(schema147, false, "Caves and Cliffs biome renames", (Map<String, String>)CavesAndCliffsRenames.RENAMES));
        Schema schema148 = pBuilder.addSchema(2841, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new ChunkProtoTickListFix(schema148));
        Schema schema149 = pBuilder.addSchema(2842, V2842::new);
        pBuilder.addFixer((DataFix)new ChunkRenamesFix(schema149));
        Schema schema150 = pBuilder.addSchema(2843, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new OverreachingTickFix(schema150));
        pBuilder.addFixer((DataFix)new RenameBiomesFix(schema150, false, "Remove Deep Warm Ocean", Map.of("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema151 = pBuilder.addSchema(2846, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new AdvancementsRenameFix(schema151, false, "Rename some C&C part 2 advancements", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema152 = pBuilder.addSchema(2852, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema152));
        Schema schema153 = pBuilder.addSchema(2967, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new StructureSettingsFlattenFix(schema153));
        Schema schema154 = pBuilder.addSchema(2970, SAME_NAMESPACED);
        pBuilder.addFixer((DataFix)new StructuresBecomeConfiguredFix(schema154));
    }

    private static UnaryOperator<String> createRenamer(Map<String, String> pRenameMap) {
        return p_14528_ -> pRenameMap.getOrDefault(p_14528_, (String)p_14528_);
    }

    private static UnaryOperator<String> createRenamer(String pOldName, String pNewName) {
        return p_14523_ -> Objects.equals(p_14523_, pOldName) ? pNewName : p_14523_;
    }
}

