/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import net.minecraft.util.datafix.fixes.References;

public class AttributesRename
extends DataFix {
    private static final Map<String, String> RENAMES = ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"generic.max_health").put((Object)"Max Health", (Object)"generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"horse.jump_strength").put((Object)"Jump Strength", (Object)"horse.jump_strength").put((Object)"generic.followRange", (Object)"generic.follow_range").put((Object)"Follow Range", (Object)"generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"generic.movement_speed").put((Object)"Movement Speed", (Object)"generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"generic.flying_speed").put((Object)"Flying Speed", (Object)"generic.flying_speed").put((Object)"generic.attackDamage", (Object)"generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"generic.attack_speed").put((Object)"generic.armorToughness", (Object)"generic.armor_toughness").build();

    public AttributesRename(Schema p_14671_) {
        super(p_14671_, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder opticfinder = type.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("Rename ItemStack Attributes", type, p_14674_ -> p_14674_.updateTyped(opticfinder, AttributesRename::fixItemStackTag)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("Rename Entity Attributes", this.getInputSchema().getType(References.ENTITY), AttributesRename::fixEntity), this.fixTypeEverywhereTyped("Rename Player Attributes", this.getInputSchema().getType(References.PLAYER), AttributesRename::fixEntity)});
    }

    private static Dynamic<?> fixName(Dynamic<?> p_14678_) {
        return (Dynamic)DataFixUtils.orElse(p_14678_.asString().result().map(p_14680_ -> RENAMES.getOrDefault(p_14680_, (String)p_14680_)).map(arg_0 -> p_14678_.createString(arg_0)), p_14678_);
    }

    private static Typed<?> fixItemStackTag(Typed<?> p_14676_) {
        return p_14676_.update(DSL.remainderFinder(), p_14694_ -> p_14694_.update("AttributeModifiers", p_145080_ -> (Dynamic)DataFixUtils.orElse(p_145080_.asStreamOpt().result().map(p_145074_ -> p_145074_.map(p_145082_ -> p_145082_.update("AttributeName", AttributesRename::fixName))).map(arg_0 -> ((Dynamic)p_145080_).createList(arg_0)), (Object)p_145080_)));
    }

    private static Typed<?> fixEntity(Typed<?> p_14684_) {
        return p_14684_.update(DSL.remainderFinder(), p_14686_ -> p_14686_.update("Attributes", p_145076_ -> (Dynamic)DataFixUtils.orElse(p_145076_.asStreamOpt().result().map(p_145072_ -> p_145072_.map(p_145078_ -> p_145078_.update("Name", AttributesRename::fixName))).map(arg_0 -> ((Dynamic)p_145076_).createList(arg_0)), (Object)p_145076_)));
    }
}

