/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class EntityEquipmentToArmorAndHandFix
extends DataFix {
    public EntityEquipmentToArmorAndHandFix(Schema p_15417_, boolean p_15418_) {
        super(p_15417_, p_15418_);
    }

    public TypeRewriteRule makeRule() {
        return this.cap(this.getInputSchema().getTypeRaw(References.ITEM_STACK));
    }

    private <IS> TypeRewriteRule cap(Type<IS> p_15427_) {
        Type type = DSL.and((Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(p_15427_))), (Type)DSL.remainderType());
        Type type1 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(p_15427_))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(p_15427_))), (Type)DSL.remainderType());
        OpticFinder opticfinder = DSL.typeFinder((Type)type);
        OpticFinder opticfinder1 = DSL.fieldFinder((String)"Equipment", (Type)DSL.list(p_15427_));
        return this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix", this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY), p_15425_ -> {
            Either either = Either.right((Object)DSL.unit());
            Either either1 = Either.right((Object)DSL.unit());
            Dynamic dynamic = (Dynamic)p_15425_.getOrCreate(DSL.remainderFinder());
            Optional optional = p_15425_.getOptional(opticfinder1);
            if (optional.isPresent()) {
                List list = (List)optional.get();
                Object is = ((Pair)p_15427_.read(dynamic.emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
                if (!list.isEmpty()) {
                    either = Either.left((Object)Lists.newArrayList((Object[])new Object[]{list.get(0), is}));
                }
                if (list.size() > 1) {
                    ArrayList list1 = Lists.newArrayList((Object[])new Object[]{is, is, is, is});
                    int i = 1;
                    while (i < Math.min(list.size(), 5)) {
                        list1.set(i - 1, list.get(i));
                        ++i;
                    }
                    either1 = Either.left((Object)list1);
                }
            }
            Dynamic dynamic2 = dynamic;
            Optional optional1 = dynamic.get("DropChances").asStreamOpt().result();
            if (optional1.isPresent()) {
                Iterator iterator = Stream.concat((Stream)optional1.get(), Stream.generate(() -> dynamic2.createInt(0))).iterator();
                float f = ((Dynamic)iterator.next()).asFloat(0.0f);
                if (!dynamic.get("HandDropChances").result().isPresent()) {
                    Dynamic dynamic1 = dynamic.createList(Stream.of(Float.valueOf(f), Float.valueOf(0.0f)).map(arg_0 -> ((Dynamic)dynamic).createFloat(arg_0)));
                    dynamic = dynamic.set("HandDropChances", dynamic1);
                }
                if (!dynamic.get("ArmorDropChances").result().isPresent()) {
                    Dynamic dynamic3 = dynamic.createList(Stream.of(Float.valueOf(((Dynamic)iterator.next()).asFloat(0.0f)), Float.valueOf(((Dynamic)iterator.next()).asFloat(0.0f)), Float.valueOf(((Dynamic)iterator.next()).asFloat(0.0f)), Float.valueOf(((Dynamic)iterator.next()).asFloat(0.0f))).map(arg_0 -> ((Dynamic)dynamic).createFloat(arg_0)));
                    dynamic = dynamic.set("ArmorDropChances", dynamic3);
                }
                dynamic = dynamic.remove("DropChances");
            }
            return p_15425_.set(opticfinder, type1, (Object)Pair.of((Object)either, (Object)Pair.of((Object)either1, (Object)dynamic)));
        });
    }
}

