/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.References;

public class EntityMinecartIdentifiersFix
extends DataFix {
    private static final List<String> MINECART_BY_ID = Lists.newArrayList((Object[])new String[]{"MinecartRideable", "MinecartChest", "MinecartFurnace"});

    public EntityMinecartIdentifiersFix(Schema p_15479_, boolean p_15480_) {
        super(p_15479_, p_15480_);
    }

    public TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType taggedchoicetype = this.getInputSchema().findChoiceType(References.ENTITY);
        TaggedChoice.TaggedChoiceType taggedchoicetype1 = this.getOutputSchema().findChoiceType(References.ENTITY);
        return this.fixTypeEverywhere("EntityMinecartIdentifiersFix", (Type)taggedchoicetype, (Type)taggedchoicetype1, p_15485_ -> p_145290_ -> {
            if (!Objects.equals(p_145290_.getFirst(), "Minecart")) {
                return p_145290_;
            }
            Typed typed = (Typed)taggedchoicetype.point(p_15485_, (Object)"Minecart", p_145290_.getSecond()).orElseThrow(IllegalStateException::new);
            Dynamic dynamic = (Dynamic)typed.getOrCreate(DSL.remainderFinder());
            int i = dynamic.get("Type").asInt(0);
            String s = i > 0 && i < MINECART_BY_ID.size() ? MINECART_BY_ID.get(i) : "MinecartRideable";
            return Pair.of((Object)s, (Object)((DataResult)typed.write().map(p_145294_ -> ((Type)taggedchoicetype1.types().get(s)).read(p_145294_)).result().orElseThrow(() -> new IllegalStateException("Could not read the new minecart."))));
        });
    }
}

