/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.SimpleEntityRenameFix;

public class EntityZombieSplitFix
extends SimpleEntityRenameFix {
    public EntityZombieSplitFix(Schema p_15798_, boolean p_15799_) {
        super("EntityZombieSplitFix", p_15798_, p_15799_);
    }

    @Override
    protected Pair<String, Dynamic<?>> getNewNameAndTag(String pName, Dynamic<?> pTag) {
        if (Objects.equals("Zombie", pName)) {
            String s = "Zombie";
            int i = pTag.get("ZombieType").asInt(0);
            switch (i) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    s = "ZombieVillager";
                    pTag = pTag.set("Profession", pTag.createInt(i - 1));
                    break;
                }
                case 6: {
                    s = "Husk";
                }
            }
            pTag = pTag.remove("ZombieType");
            return Pair.of((Object)s, (Object)pTag);
        }
        return Pair.of((Object)pName, pTag);
    }
}

