/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public abstract class SimplestEntityRenameFix
extends DataFix {
    private final String name;

    public SimplestEntityRenameFix(String p_16911_, Schema p_16912_, boolean p_16913_) {
        super(p_16912_, p_16913_);
        this.name = p_16911_;
    }

    public TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType taggedchoicetype = this.getInputSchema().findChoiceType(References.ENTITY);
        TaggedChoice.TaggedChoiceType taggedchoicetype1 = this.getOutputSchema().findChoiceType(References.ENTITY);
        Type type = DSL.named((String)References.ENTITY_NAME.typeName(), NamespacedSchema.namespacedString());
        if (!Objects.equals(this.getOutputSchema().getType(References.ENTITY_NAME), type)) {
            throw new IllegalStateException("Entity name type is not what was expected.");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere(this.name, (Type)taggedchoicetype, (Type)taggedchoicetype1, p_16921_ -> p_145688_ -> p_145688_.mapFirst(p_145692_ -> {
            String s = this.rename((String)p_145692_);
            Type type1 = (Type)taggedchoicetype.types().get(p_145692_);
            Type type2 = (Type)taggedchoicetype1.types().get(s);
            if (!type2.equals((Object)type1, true, true)) {
                throw new IllegalStateException(String.format("Dynamic type check failed: %s not equal to %s", type2, type1));
            }
            return s;
        })), (TypeRewriteRule)this.fixTypeEverywhere(String.valueOf(this.name) + " for entity name", type, p_16929_ -> p_145694_ -> p_145694_.mapSecond(this::rename)));
    }

    protected abstract String rename(String var1);
}

