/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenSettingsFix
extends DataFix {
    private static final String VILLAGE = "minecraft:village";
    private static final String DESERT_PYRAMID = "minecraft:desert_pyramid";
    private static final String IGLOO = "minecraft:igloo";
    private static final String JUNGLE_TEMPLE = "minecraft:jungle_pyramid";
    private static final String SWAMP_HUT = "minecraft:swamp_hut";
    private static final String PILLAGER_OUTPOST = "minecraft:pillager_outpost";
    private static final String END_CITY = "minecraft:endcity";
    private static final String WOODLAND_MANSION = "minecraft:mansion";
    private static final String OCEAN_MONUMENT = "minecraft:monument";
    private static final ImmutableMap<String, StructureFeatureConfiguration> DEFAULTS = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new StructureFeatureConfiguration(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new StructureFeatureConfiguration(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new StructureFeatureConfiguration(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new StructureFeatureConfiguration(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new StructureFeatureConfiguration(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new StructureFeatureConfiguration(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new StructureFeatureConfiguration(80, 20, 10387319)).build();

    public WorldGenSettingsFix(Schema p_17173_) {
        super(p_17173_, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(References.WORLD_GEN_SETTINGS), p_17184_ -> p_17184_.update(DSL.remainderFinder(), WorldGenSettingsFix::fix));
    }

    private static <T> Dynamic<T> noise(long p_17175_, DynamicLike<T> p_17176_, Dynamic<T> p_17177_, Dynamic<T> p_17178_) {
        return p_17176_.createMap((Map)ImmutableMap.of((Object)p_17176_.createString("type"), (Object)p_17176_.createString("minecraft:noise"), (Object)p_17176_.createString("biome_source"), p_17178_, (Object)p_17176_.createString("seed"), (Object)p_17176_.createLong(p_17175_), (Object)p_17176_.createString("settings"), p_17177_));
    }

    private static <T> Dynamic<T> vanillaBiomeSource(Dynamic<T> p_17196_, long p_17197_, boolean p_17198_, boolean p_17199_) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)p_17196_.createString("type"), (Object)p_17196_.createString("minecraft:vanilla_layered")).put((Object)p_17196_.createString("seed"), (Object)p_17196_.createLong(p_17197_)).put((Object)p_17196_.createString("large_biomes"), (Object)p_17196_.createBoolean(p_17199_));
        if (p_17198_) {
            builder.put((Object)p_17196_.createString("legacy_biome_init_layer"), (Object)p_17196_.createBoolean(p_17198_));
        }
        return p_17196_.createMap((Map)builder.build());
    }

    private static <T> Dynamic<T> fix(Dynamic<T> p_17186_) {
        Dynamic<T> dynamic;
        boolean flag;
        Optional optional1;
        long i;
        DynamicOps dynamicops;
        block18: {
            String $$28;
            Optional optional;
            block19: {
                block17: {
                    dynamicops = p_17186_.getOps();
                    i = p_17186_.get("RandomSeed").asLong(0L);
                    optional = p_17186_.get("generatorName").asString().map(p_17227_ -> p_17227_.toLowerCase(Locale.ROOT)).result();
                    optional1 = p_17186_.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> optional.equals(Optional.of("customized")) ? p_17186_.get("generatorOptions").asString().result() : Optional.empty());
                    flag = false;
                    if (!optional.equals(Optional.of("customized"))) break block17;
                    dynamic = WorldGenSettingsFix.defaultOverworld(p_17186_, i);
                    break block18;
                }
                if (optional.isPresent()) break block19;
                dynamic = WorldGenSettingsFix.defaultOverworld(p_17186_, i);
                break block18;
            }
            switch ($$28 = (String)optional.get()) {
                case "flat": {
                    OptionalDynamic optionaldynamic = p_17186_.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> map = WorldGenSettingsFix.fixFlatStructures(dynamicops, optionaldynamic);
                    dynamic = p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("type"), (Object)p_17186_.createString("minecraft:flat"), (Object)p_17186_.createString("settings"), (Object)p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("structures"), (Object)p_17186_.createMap(map), (Object)p_17186_.createString("layers"), (Object)optionaldynamic.get("layers").result().orElseGet(() -> p_17186_.createList(Stream.of(p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("height"), (Object)p_17186_.createInt(1), (Object)p_17186_.createString("block"), (Object)p_17186_.createString("minecraft:bedrock"))), p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("height"), (Object)p_17186_.createInt(2), (Object)p_17186_.createString("block"), (Object)p_17186_.createString("minecraft:dirt"))), p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("height"), (Object)p_17186_.createInt(1), (Object)p_17186_.createString("block"), (Object)p_17186_.createString("minecraft:grass_block")))))), (Object)p_17186_.createString("biome"), (Object)p_17186_.createString(optionaldynamic.get("biome").asString("minecraft:plains"))))));
                    break;
                }
                case "debug_all_block_states": {
                    dynamic = p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("type"), (Object)p_17186_.createString("minecraft:debug")));
                    break;
                }
                case "buffet": {
                    Dynamic dynamic3;
                    Dynamic dynamic1;
                    OptionalDynamic optionaldynamic1 = p_17186_.get("generatorOptions");
                    OptionalDynamic optionaldynamic2 = optionaldynamic1.get("chunk_generator");
                    Optional optional2 = optionaldynamic2.get("type").asString().result();
                    if (Objects.equals(optional2, Optional.of("minecraft:caves"))) {
                        dynamic1 = p_17186_.createString("minecraft:caves");
                        flag = true;
                    } else {
                        dynamic1 = Objects.equals(optional2, Optional.of("minecraft:floating_islands")) ? p_17186_.createString("minecraft:floating_islands") : p_17186_.createString("minecraft:overworld");
                    }
                    Dynamic dynamic2 = optionaldynamic1.get("biome_source").result().orElseGet(() -> p_17186_.createMap((Map)ImmutableMap.of((Object)p_17186_.createString("type"), (Object)p_17186_.createString("minecraft:fixed"))));
                    if (dynamic2.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String s1 = dynamic2.get("options").get("biomes").asStream().findFirst().flatMap(p_17259_ -> p_17259_.asString().result()).orElse("minecraft:ocean");
                        dynamic3 = dynamic2.remove("options").set("biome", p_17186_.createString(s1));
                    } else {
                        dynamic3 = dynamic2;
                    }
                    dynamic = WorldGenSettingsFix.noise(i, p_17186_, dynamic1, dynamic3);
                    break;
                }
                default: {
                    boolean flag6 = ((String)optional.get()).equals("default");
                    boolean flag1 = ((String)optional.get()).equals("default_1_1") || flag6 && p_17186_.get("generatorVersion").asInt(0) == 0;
                    boolean flag2 = ((String)optional.get()).equals("amplified");
                    boolean flag3 = ((String)optional.get()).equals("largebiomes");
                    dynamic = WorldGenSettingsFix.noise(i, p_17186_, p_17186_.createString(flag2 ? "minecraft:amplified" : "minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(p_17186_, i, flag1, flag3));
                }
            }
        }
        boolean flag4 = p_17186_.get("MapFeatures").asBoolean(true);
        boolean flag5 = p_17186_.get("BonusChest").asBoolean(false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(dynamicops.createString("seed"), dynamicops.createLong(i));
        builder.put(dynamicops.createString("generate_features"), dynamicops.createBoolean(flag4));
        builder.put(dynamicops.createString("bonus_chest"), dynamicops.createBoolean(flag5));
        builder.put(dynamicops.createString("dimensions"), WorldGenSettingsFix.vanillaLevels(p_17186_, i, dynamic, flag));
        optional1.ifPresent(p_17182_ -> builder.put(dynamicops.createString("legacy_custom_options"), dynamicops.createString(p_17182_)));
        return new Dynamic(dynamicops, dynamicops.createMap((Map)builder.build()));
    }

    protected static <T> Dynamic<T> defaultOverworld(Dynamic<T> p_17188_, long p_17189_) {
        return WorldGenSettingsFix.noise(p_17189_, p_17188_, p_17188_.createString("minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(p_17188_, p_17189_, false, false));
    }

    protected static <T> T vanillaLevels(Dynamic<T> p_17191_, long p_17192_, Dynamic<T> p_17193_, boolean p_17194_) {
        DynamicOps dynamicops = p_17191_.getOps();
        return (T)dynamicops.createMap((Map)ImmutableMap.of((Object)dynamicops.createString("minecraft:overworld"), (Object)dynamicops.createMap((Map)ImmutableMap.of((Object)dynamicops.createString("type"), (Object)dynamicops.createString("minecraft:overworld" + (p_17194_ ? "_caves" : "")), (Object)dynamicops.createString("generator"), (Object)p_17193_.getValue())), (Object)dynamicops.createString("minecraft:the_nether"), (Object)dynamicops.createMap((Map)ImmutableMap.of((Object)dynamicops.createString("type"), (Object)dynamicops.createString("minecraft:the_nether"), (Object)dynamicops.createString("generator"), (Object)WorldGenSettingsFix.noise(p_17192_, p_17191_, p_17191_.createString("minecraft:nether"), p_17191_.createMap((Map)ImmutableMap.of((Object)p_17191_.createString("type"), (Object)p_17191_.createString("minecraft:multi_noise"), (Object)p_17191_.createString("seed"), (Object)p_17191_.createLong(p_17192_), (Object)p_17191_.createString("preset"), (Object)p_17191_.createString("minecraft:nether")))).getValue())), (Object)dynamicops.createString("minecraft:the_end"), (Object)dynamicops.createMap((Map)ImmutableMap.of((Object)dynamicops.createString("type"), (Object)dynamicops.createString("minecraft:the_end"), (Object)dynamicops.createString("generator"), (Object)WorldGenSettingsFix.noise(p_17192_, p_17191_, p_17191_.createString("minecraft:end"), p_17191_.createMap((Map)ImmutableMap.of((Object)p_17191_.createString("type"), (Object)p_17191_.createString("minecraft:the_end"), (Object)p_17191_.createString("seed"), (Object)p_17191_.createLong(p_17192_)))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> fixFlatStructures(DynamicOps<T> p_17218_, OptionalDynamic<T> p_17219_) {
        MutableInt mutableint = new MutableInt(32);
        MutableInt mutableint1 = new MutableInt(3);
        MutableInt mutableint2 = new MutableInt(128);
        MutableBoolean mutableboolean = new MutableBoolean(false);
        HashMap map = Maps.newHashMap();
        if (!p_17219_.result().isPresent()) {
            mutableboolean.setTrue();
            map.put(VILLAGE, (StructureFeatureConfiguration)DEFAULTS.get((Object)VILLAGE));
        }
        p_17219_.get("structures").flatMap(Dynamic::getMapValues).result().ifPresent(p_17257_ -> p_17257_.forEach((p_145823_, p_145824_) -> p_145824_.getMapValues().result().ifPresent(p_145816_ -> p_145816_.forEach((p_145807_, p_145808_) -> {
            block46: {
                String s2;
                String s1;
                String s;
                block44: {
                    s = p_145823_.asString("");
                    s1 = p_145807_.asString("");
                    s2 = p_145808_.asString("");
                    if (!"stronghold".equals(s)) break block44;
                    mutableboolean.setTrue();
                    switch (s1) {
                        case "distance": {
                            mutableint.setValue(WorldGenSettingsFix.getInt(s2, mutableint.getValue(), 1));
                            return;
                        }
                        case "spread": {
                            mutableint1.setValue(WorldGenSettingsFix.getInt(s2, mutableint1.getValue(), 1));
                            return;
                        }
                        case "count": {
                            mutableint2.setValue(WorldGenSettingsFix.getInt(s2, mutableint2.getValue(), 1));
                            return;
                        }
                    }
                    break block46;
                }
                switch (s1) {
                    case "distance": {
                        switch (s) {
                            case "village": {
                                WorldGenSettingsFix.setSpacing(map, VILLAGE, s2, 9);
                                return;
                            }
                            case "biome_1": {
                                WorldGenSettingsFix.setSpacing(map, DESERT_PYRAMID, s2, 9);
                                WorldGenSettingsFix.setSpacing(map, IGLOO, s2, 9);
                                WorldGenSettingsFix.setSpacing(map, JUNGLE_TEMPLE, s2, 9);
                                WorldGenSettingsFix.setSpacing(map, SWAMP_HUT, s2, 9);
                                WorldGenSettingsFix.setSpacing(map, PILLAGER_OUTPOST, s2, 9);
                                return;
                            }
                            case "endcity": {
                                WorldGenSettingsFix.setSpacing(map, END_CITY, s2, 1);
                                return;
                            }
                            case "mansion": {
                                WorldGenSettingsFix.setSpacing(map, WOODLAND_MANSION, s2, 1);
                                return;
                            }
                        }
                        return;
                    }
                    case "separation": {
                        if ("oceanmonument".equals(s)) {
                            StructureFeatureConfiguration worldgensettingsfix$structurefeatureconfiguration = map.getOrDefault(OCEAN_MONUMENT, (StructureFeatureConfiguration)DEFAULTS.get((Object)OCEAN_MONUMENT));
                            int i = WorldGenSettingsFix.getInt(s2, worldgensettingsfix$structurefeatureconfiguration.separation, 1);
                            map.put(OCEAN_MONUMENT, new StructureFeatureConfiguration(i, worldgensettingsfix$structurefeatureconfiguration.separation, worldgensettingsfix$structurefeatureconfiguration.salt));
                        }
                        return;
                    }
                    case "spacing": {
                        if ("oceanmonument".equals(s)) {
                            WorldGenSettingsFix.setSpacing(map, OCEAN_MONUMENT, s2, 1);
                        }
                        return;
                    }
                }
            }
        }))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)p_17219_.createString("structures"), (Object)p_17219_.createMap(map.entrySet().stream().collect(Collectors.toMap(p_17225_ -> p_17219_.createString((String)p_17225_.getKey()), p_17222_ -> ((StructureFeatureConfiguration)p_17222_.getValue()).serialize(p_17218_)))));
        if (mutableboolean.isTrue()) {
            builder.put((Object)p_17219_.createString("stronghold"), (Object)p_17219_.createMap((Map)ImmutableMap.of((Object)p_17219_.createString("distance"), (Object)p_17219_.createInt(mutableint.getValue().intValue()), (Object)p_17219_.createString("spread"), (Object)p_17219_.createInt(mutableint1.getValue().intValue()), (Object)p_17219_.createString("count"), (Object)p_17219_.createInt(mutableint2.getValue().intValue()))));
        }
        return builder.build();
    }

    private static int getInt(String p_17229_, int p_17230_) {
        return NumberUtils.toInt((String)p_17229_, (int)p_17230_);
    }

    private static int getInt(String p_17232_, int p_17233_, int p_17234_) {
        return Math.max(p_17234_, WorldGenSettingsFix.getInt(p_17232_, p_17233_));
    }

    private static void setSpacing(Map<String, StructureFeatureConfiguration> p_17236_, String p_17237_, String p_17238_, int p_17239_) {
        StructureFeatureConfiguration worldgensettingsfix$structurefeatureconfiguration = p_17236_.getOrDefault(p_17237_, (StructureFeatureConfiguration)DEFAULTS.get((Object)p_17237_));
        int i = WorldGenSettingsFix.getInt(p_17238_, worldgensettingsfix$structurefeatureconfiguration.spacing, p_17239_);
        p_17236_.put(p_17237_, new StructureFeatureConfiguration(i, worldgensettingsfix$structurefeatureconfiguration.separation, worldgensettingsfix$structurefeatureconfiguration.salt));
    }

    static final class StructureFeatureConfiguration {
        public static final Codec<StructureFeatureConfiguration> CODEC = RecordCodecBuilder.create(p_17279_ -> p_17279_.group((App)Codec.INT.fieldOf("spacing").forGetter(p_145830_ -> p_145830_.spacing), (App)Codec.INT.fieldOf("separation").forGetter(p_145828_ -> p_145828_.separation), (App)Codec.INT.fieldOf("salt").forGetter(p_145826_ -> p_145826_.salt)).apply((Applicative)p_17279_, StructureFeatureConfiguration::new));
        final int spacing;
        final int separation;
        final int salt;

        public StructureFeatureConfiguration(int p_17271_, int p_17272_, int p_17273_) {
            this.spacing = p_17271_;
            this.separation = p_17272_;
            this.salt = p_17273_;
        }

        public <T> Dynamic<T> serialize(DynamicOps<T> p_17277_) {
            return new Dynamic(p_17277_, CODEC.encodeStart(p_17277_, (Object)this).result().orElse(p_17277_.emptyMap()));
        }
    }
}

