/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;

public final class NetworkPacketSummary {
    private final PacketCountAndSize totalPacketCountAndSize;
    private final List<Pair<PacketIdentification, PacketCountAndSize>> largestSizeContributors;
    private final Duration recordingDuration;

    public NetworkPacketSummary(Duration p_185738_, List<Pair<PacketIdentification, PacketCountAndSize>> p_185739_) {
        this.recordingDuration = p_185738_;
        this.totalPacketCountAndSize = p_185739_.stream().map(Pair::getSecond).reduce(PacketCountAndSize::add).orElseGet(() -> new PacketCountAndSize(0L, 0L));
        this.largestSizeContributors = p_185739_.stream().sorted(Comparator.comparing(Pair::getSecond, PacketCountAndSize.SIZE_THEN_COUNT)).limit(10L).toList();
    }

    public double getCountsPerSecond() {
        return (double)this.totalPacketCountAndSize.totalCount / (double)this.recordingDuration.getSeconds();
    }

    public double getSizePerSecond() {
        return (double)this.totalPacketCountAndSize.totalSize / (double)this.recordingDuration.getSeconds();
    }

    public long getTotalCount() {
        return this.totalPacketCountAndSize.totalCount;
    }

    public long getTotalSize() {
        return this.totalPacketCountAndSize.totalSize;
    }

    public List<Pair<PacketIdentification, PacketCountAndSize>> largestSizeContributors() {
        return this.largestSizeContributors;
    }

    public record PacketCountAndSize(long totalCount, long totalSize) {
        static final Comparator<PacketCountAndSize> SIZE_THEN_COUNT = Comparator.comparing(PacketCountAndSize::totalSize).thenComparing(PacketCountAndSize::totalCount).reversed();

        PacketCountAndSize add(PacketCountAndSize p_185755_) {
            return new PacketCountAndSize(this.totalCount + p_185755_.totalCount, this.totalSize + p_185755_.totalSize);
        }
    }

    public record PacketIdentification(PacketFlow direction, int protocolId, int packetId) {
        private static final Map<PacketIdentification, String> PACKET_NAME_BY_ID;

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ConnectionProtocol[] connectionProtocolArray = ConnectionProtocol.values();
            int n = connectionProtocolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionProtocol connectionprotocol = connectionProtocolArray[n2];
                PacketFlow[] packetFlowArray = PacketFlow.values();
                int n3 = packetFlowArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    PacketFlow packetflow = packetFlowArray[n4];
                    Int2ObjectMap<Class<? extends Packet<?>>> int2objectmap = connectionprotocol.getPacketsByIds(packetflow);
                    int2objectmap.forEach((p_185775_, p_185776_) -> builder.put((Object)new PacketIdentification(packetflow, connectionprotocol.getId(), (int)p_185775_), (Object)p_185776_.getSimpleName()));
                    ++n4;
                }
                ++n2;
            }
            PACKET_NAME_BY_ID = builder.build();
        }

        public String packetName() {
            return PACKET_NAME_BY_ID.getOrDefault(this, "unknown");
        }

        public static PacketIdentification from(RecordedEvent p_185778_) {
            return new PacketIdentification(p_185778_.getEventType().getName().equals("minecraft.PacketSent") ? PacketFlow.CLIENTBOUND : PacketFlow.SERVERBOUND, p_185778_.getInt("protocolId"), p_185778_.getInt("packetId"));
        }
    }
}

