/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;

public class SimpleWeightedRandomList<E>
extends WeightedRandomList<WeightedEntry.Wrapper<E>> {
    public static <E> Codec<SimpleWeightedRandomList<E>> wrappedCodecAllowingEmpty(Codec<E> p_185861_) {
        return WeightedEntry.Wrapper.codec(p_185861_).listOf().xmap(SimpleWeightedRandomList::new, WeightedRandomList::unwrap);
    }

    public static <E> Codec<SimpleWeightedRandomList<E>> wrappedCodec(Codec<E> pElementCodec) {
        return ExtraCodecs.nonEmptyList(WeightedEntry.Wrapper.codec(pElementCodec).listOf()).xmap(SimpleWeightedRandomList::new, WeightedRandomList::unwrap);
    }

    SimpleWeightedRandomList(List<? extends WeightedEntry.Wrapper<E>> p_146262_) {
        super(p_146262_);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> SimpleWeightedRandomList<E> empty() {
        return new SimpleWeightedRandomList<E>(List.of());
    }

    public static <E> SimpleWeightedRandomList<E> single(E p_185863_) {
        return new SimpleWeightedRandomList<E>(List.of(WeightedEntry.wrap(p_185863_, 1)));
    }

    public Optional<E> getRandomValue(Random pRandom) {
        return this.getRandom(pRandom).map(WeightedEntry.Wrapper::getData);
    }

    public static class Builder<E> {
        private final ImmutableList.Builder<WeightedEntry.Wrapper<E>> result = ImmutableList.builder();

        public Builder<E> add(E pData, int pWeight) {
            this.result.add(WeightedEntry.wrap(pData, pWeight));
            return this;
        }

        public SimpleWeightedRandomList<E> build() {
            return new SimpleWeightedRandomList(this.result.build());
        }
    }
}

