/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom {
    private WeightedRandom() {
    }

    public static int getTotalWeight(List<? extends WeightedEntry> pEntries) {
        long i = 0L;
        for (WeightedEntry weightedEntry : pEntries) {
            i += (long)weightedEntry.getWeight().asInt();
        }
        if (i > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)i;
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(Random pRandom, List<T> pEntries, int pTotalWeight) {
        if (pTotalWeight < 0) {
            throw Util.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (pTotalWeight == 0) {
            return Optional.empty();
        }
        int i = pRandom.nextInt(pTotalWeight);
        return WeightedRandom.getWeightedItem(pEntries, i);
    }

    public static <T extends WeightedEntry> Optional<T> getWeightedItem(List<T> pEntries, int pWeightedIndex) {
        for (WeightedEntry t : pEntries) {
            if ((pWeightedIndex -= t.getWeight().asInt()) >= 0) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(Random pRandom, List<T> pEntries) {
        return WeightedRandom.getRandomItem(pRandom, pEntries, WeightedRandom.getTotalWeight(pEntries));
    }
}

