/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.ProcessorHandle;
import net.optifine.Config;
import net.optifine.util.PacketRunnable;
import org.slf4j.Logger;

public abstract class BlockableEventLoop<R extends Runnable>
implements ProfilerMeasured,
ProcessorHandle<R>,
Executor {
    private final String name;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Queue<R> pendingRunnables = Queues.newConcurrentLinkedQueue();
    private int blockingCount;

    protected BlockableEventLoop(String p_18686_) {
        this.name = p_18686_;
        MetricsRegistry.INSTANCE.add(this);
    }

    protected abstract R wrapRunnable(Runnable var1);

    protected abstract boolean shouldRun(R var1);

    public boolean isSameThread() {
        return Thread.currentThread() == this.getRunningThread();
    }

    protected abstract Thread getRunningThread();

    protected boolean scheduleExecutables() {
        return !this.isSameThread();
    }

    public int getPendingTasksCount() {
        return this.pendingRunnables.size();
    }

    @Override
    public String name() {
        return this.name;
    }

    public <V> CompletableFuture<V> submit(Supplier<V> pTask) {
        return this.scheduleExecutables() ? CompletableFuture.supplyAsync(pTask, this) : CompletableFuture.completedFuture(pTask.get());
    }

    private CompletableFuture<Void> submitAsync(Runnable pTask) {
        return CompletableFuture.supplyAsync(() -> {
            pTask.run();
            return null;
        }, this);
    }

    public CompletableFuture<Void> submit(Runnable pTask) {
        if (this.scheduleExecutables()) {
            return this.submitAsync(pTask);
        }
        pTask.run();
        return CompletableFuture.completedFuture(null);
    }

    public void executeBlocking(Runnable pTask) {
        if (!this.isSameThread()) {
            this.submitAsync(pTask).join();
        } else {
            pTask.run();
        }
    }

    @Override
    public void tell(R pTask) {
        this.pendingRunnables.add(pTask);
        LockSupport.unpark(this.getRunningThread());
    }

    @Override
    public void execute(Runnable p_18706_) {
        if (this.scheduleExecutables()) {
            this.tell(this.wrapRunnable(p_18706_));
        } else {
            p_18706_.run();
        }
    }

    public void executeIfPossible(Runnable p_201937_) {
        this.execute(p_201937_);
    }

    protected void dropAllTasks() {
        this.pendingRunnables.clear();
    }

    protected void runAllTasks() {
        int i = Integer.MAX_VALUE;
        if (Config.isLazyChunkLoading() && this == Minecraft.getInstance()) {
            i = this.getTaskCount();
        }
        while (this.pollTask()) {
            if (--i <= 0) break;
        }
    }

    public boolean pollTask() {
        Runnable r = (Runnable)this.pendingRunnables.peek();
        if (r == null) {
            return false;
        }
        if (this.blockingCount == 0 && !this.shouldRun(r)) {
            return false;
        }
        this.doRunTask((Runnable)this.pendingRunnables.remove());
        return true;
    }

    public void managedBlock(BooleanSupplier pIsDone) {
        ++this.blockingCount;
        try {
            while (!pIsDone.getAsBoolean()) {
                if (this.pollTask()) continue;
                this.waitForTasks();
            }
        }
        finally {
            --this.blockingCount;
        }
    }

    protected void waitForTasks() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void doRunTask(R pTask) {
        block2: {
            try {
                pTask.run();
            }
            catch (Exception exception) {
                LOGGER.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.name(), (Object)exception);
                if (!(exception.getCause() instanceof OutOfMemoryError)) break block2;
                OutOfMemoryError outofmemoryerror = (OutOfMemoryError)exception.getCause();
                throw outofmemoryerror;
            }
        }
    }

    @Override
    public List<MetricSampler> profiledMetrics() {
        return ImmutableList.of((Object)MetricSampler.create(String.valueOf(this.name) + "-pending-tasks", MetricCategory.EVENT_LOOPS, this::getPendingTasksCount));
    }

    private int getTaskCount() {
        if (this.pendingRunnables.isEmpty()) {
            return 0;
        }
        Runnable[] ar = this.pendingRunnables.toArray(new Runnable[this.pendingRunnables.size()]);
        double d0 = this.getChunkUpdateWeight(ar);
        if (d0 < 5.0) {
            return Integer.MAX_VALUE;
        }
        int i = ar.length;
        int j = Math.max(Config.getFpsAverage(), 1);
        double d1 = i * 10 / j;
        return this.getCount(ar, d1);
    }

    private int getCount(R[] rs, double maxWeight) {
        double d0 = 0.0;
        int i = 0;
        while (i < rs.length) {
            R r = rs[i];
            if ((d0 += this.getChunkUpdateWeight((Runnable)r)) > maxWeight) {
                return i + 1;
            }
            ++i;
        }
        return rs.length;
    }

    private double getChunkUpdateWeight(R[] rs) {
        double d0 = 0.0;
        int i = 0;
        while (i < rs.length) {
            R r = rs[i];
            d0 += this.getChunkUpdateWeight((Runnable)r);
            ++i;
        }
        return d0;
    }

    private double getChunkUpdateWeight(Runnable r) {
        if (r instanceof PacketRunnable) {
            PacketRunnable packetrunnable = (PacketRunnable)r;
            Packet packet = packetrunnable.getPacket();
            if (packet instanceof ClientboundLevelChunkWithLightPacket) {
                return 1.0;
            }
            if (packet instanceof ClientboundLightUpdatePacket) {
                return 0.2;
            }
            if (packet instanceof ClientboundForgetLevelChunkPacket) {
                return 2.6;
            }
        }
        return 0.0;
    }
}

