/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public interface StrictQueue<T, F> {
    @Nullable
    public F pop();

    public boolean push(T var1);

    public boolean isEmpty();

    public int size();

    public static final class FixedPriorityQueue
    implements StrictQueue<IntRunnable, Runnable> {
        private final Queue<Runnable>[] queues;
        private final AtomicInteger size = new AtomicInteger();

        public FixedPriorityQueue(int p_18773_) {
            this.queues = new Queue[p_18773_];
            int i = 0;
            while (i < p_18773_) {
                this.queues[i] = Queues.newConcurrentLinkedQueue();
                ++i;
            }
        }

        @Override
        @Nullable
        public Runnable pop() {
            Queue<Runnable>[] queueArray = this.queues;
            int n = this.queues.length;
            int n2 = 0;
            while (n2 < n) {
                Queue<Runnable> queue = queueArray[n2];
                Runnable runnable = queue.poll();
                if (runnable != null) {
                    this.size.decrementAndGet();
                    return runnable;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public boolean push(IntRunnable pValue) {
            int i = pValue.priority;
            if (i < this.queues.length && i >= 0) {
                this.queues[i].add(pValue);
                this.size.incrementAndGet();
                return true;
            }
            throw new IndexOutOfBoundsException("Priority %d not supported. Expected range [0-%d]".formatted(i, this.queues.length - 1));
        }

        @Override
        public boolean isEmpty() {
            return this.size.get() == 0;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    }

    public static final class IntRunnable
    implements Runnable {
        final int priority;
        private final Runnable task;

        public IntRunnable(int p_18786_, Runnable p_18787_) {
            this.priority = p_18786_;
            this.task = p_18787_;
        }

        @Override
        public void run() {
            this.task.run();
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static final class QueueStrictQueue<T>
    implements StrictQueue<T, T> {
        private final Queue<T> queue;

        public QueueStrictQueue(Queue<T> p_18792_) {
            this.queue = p_18792_;
        }

        @Override
        @Nullable
        public T pop() {
            return this.queue.poll();
        }

        @Override
        public boolean push(T pValue) {
            return this.queue.add(pValue);
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

