/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class BiasedToBottomInt
extends IntProvider {
    public static final Codec<BiasedToBottomInt> CODEC = RecordCodecBuilder.create(p_146373_ -> p_146373_.group((App)Codec.INT.fieldOf("min_inclusive").forGetter(p_146381_ -> p_146381_.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(p_146378_ -> p_146378_.maxInclusive)).apply((Applicative)p_146373_, BiasedToBottomInt::new)).comapFlatMap(p_146371_ -> p_146371_.maxInclusive < p_146371_.minInclusive ? DataResult.error((String)("Max must be at least min, min_inclusive: " + p_146371_.minInclusive + ", max_inclusive: " + p_146371_.maxInclusive)) : DataResult.success((Object)p_146371_), Function.identity());
    private final int minInclusive;
    private final int maxInclusive;

    private BiasedToBottomInt(int p_146364_, int p_146365_) {
        this.minInclusive = p_146364_;
        this.maxInclusive = p_146365_;
    }

    public static BiasedToBottomInt of(int p_146368_, int p_146369_) {
        return new BiasedToBottomInt(p_146368_, p_146369_);
    }

    @Override
    public int sample(Random p_146375_) {
        return this.minInclusive + p_146375_.nextInt(p_146375_.nextInt(this.maxInclusive - this.minInclusive + 1) + 1);
    }

    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.BIASED_TO_BOTTOM;
    }

    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

