/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class ClampedNormalFloat
extends FloatProvider {
    public static final Codec<ClampedNormalFloat> CODEC = RecordCodecBuilder.create(p_146431_ -> p_146431_.group((App)Codec.FLOAT.fieldOf("mean").forGetter(p_146449_ -> Float.valueOf(p_146449_.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(p_146447_ -> Float.valueOf(p_146447_.deviation)), (App)Codec.FLOAT.fieldOf("min").forGetter(p_146445_ -> Float.valueOf(p_146445_.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(p_146442_ -> Float.valueOf(p_146442_.max))).apply((Applicative)p_146431_, ClampedNormalFloat::new)).comapFlatMap(p_146429_ -> p_146429_.max < p_146429_.min ? DataResult.error((String)("Max must be larger than min: [" + p_146429_.min + ", " + p_146429_.max + "]")) : DataResult.success((Object)p_146429_), Function.identity());
    private float mean;
    private float deviation;
    private float min;
    private float max;

    public static ClampedNormalFloat of(float pMean, float pDeviation, float pMin, float pMax) {
        return new ClampedNormalFloat(pMean, pDeviation, pMin, pMax);
    }

    private ClampedNormalFloat(float p_146418_, float p_146419_, float p_146420_, float p_146421_) {
        this.mean = p_146418_;
        this.deviation = p_146419_;
        this.min = p_146420_;
        this.max = p_146421_;
    }

    @Override
    public float sample(Random pRandom) {
        return ClampedNormalFloat.sample(pRandom, this.mean, this.deviation, this.min, this.max);
    }

    public static float sample(Random pRandom, float pMean, float pDeviation, float pMin, float pMax) {
        return Mth.clamp(Mth.normal(pRandom, pMean, pDeviation), pMin, pMax);
    }

    @Override
    public float getMinValue() {
        return this.min;
    }

    @Override
    public float getMaxValue() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.min + "-" + this.max + "]";
    }
}

