/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Set;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface Container
extends Clearable {
    public static final int LARGE_MAX_STACK_SIZE = 64;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 64;
    }

    public void setChanged();

    public boolean stillValid(Player var1);

    default public void startOpen(Player pPlayer) {
    }

    default public void stopOpen(Player pPlayer) {
    }

    default public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        return true;
    }

    default public int countItem(Item pItem) {
        int i = 0;
        int j = 0;
        while (j < this.getContainerSize()) {
            ItemStack itemstack = this.getItem(j);
            if (itemstack.getItem().equals(pItem)) {
                i += itemstack.getCount();
            }
            ++j;
        }
        return i;
    }

    default public boolean hasAnyOf(Set<Item> pSet) {
        int i = 0;
        while (i < this.getContainerSize()) {
            ItemStack itemstack = this.getItem(i);
            if (pSet.contains(itemstack.getItem()) && itemstack.getCount() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

