/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ContainerHelper {
    public static ItemStack removeItem(List<ItemStack> pStacks, int pIndex, int pAmount) {
        return pIndex >= 0 && pIndex < pStacks.size() && !pStacks.get(pIndex).isEmpty() && pAmount > 0 ? pStacks.get(pIndex).split(pAmount) : ItemStack.EMPTY;
    }

    public static ItemStack takeItem(List<ItemStack> pStacks, int pIndex) {
        return pIndex >= 0 && pIndex < pStacks.size() ? pStacks.set(pIndex, ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public static CompoundTag saveAllItems(CompoundTag pTag, NonNullList<ItemStack> pList) {
        return ContainerHelper.saveAllItems(pTag, pList, true);
    }

    public static CompoundTag saveAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, boolean pSaveEmpty) {
        ListTag listtag = new ListTag();
        int i = 0;
        while (i < pList.size()) {
            ItemStack itemstack = pList.get(i);
            if (!itemstack.isEmpty()) {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putByte("Slot", (byte)i);
                itemstack.save(compoundtag);
                listtag.add(compoundtag);
            }
            ++i;
        }
        if (!listtag.isEmpty() || pSaveEmpty) {
            pTag.put("Items", listtag);
        }
        return pTag;
    }

    public static void loadAllItems(CompoundTag pTag, NonNullList<ItemStack> pList) {
        ListTag listtag = pTag.getList("Items", 10);
        int i = 0;
        while (i < listtag.size()) {
            CompoundTag compoundtag = listtag.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j >= 0 && j < pList.size()) {
                pList.set(j, ItemStack.of(compoundtag));
            }
            ++i;
        }
    }

    public static int clearOrCountMatchingItems(Container pContainer, Predicate<ItemStack> pItemPredicate, int pMaxItems, boolean pSimulate) {
        int i = 0;
        int j = 0;
        while (j < pContainer.getContainerSize()) {
            ItemStack itemstack = pContainer.getItem(j);
            int k = ContainerHelper.clearOrCountMatchingItems(itemstack, pItemPredicate, pMaxItems - i, pSimulate);
            if (k > 0 && !pSimulate && itemstack.isEmpty()) {
                pContainer.setItem(j, ItemStack.EMPTY);
            }
            i += k;
            ++j;
        }
        return i;
    }

    public static int clearOrCountMatchingItems(ItemStack pContainer, Predicate<ItemStack> pItemPredicate, int pMaxItems, boolean pSimulate) {
        if (!pContainer.isEmpty() && pItemPredicate.test(pContainer)) {
            if (pSimulate) {
                return pContainer.getCount();
            }
            int i = pMaxItems < 0 ? pContainer.getCount() : Math.min(pMaxItems, pContainer.getCount());
            pContainer.shrink(i);
            return i;
        }
        return 0;
    }
}

